
    'Tic Tac Toe
    'Requires Liberty BASIC v1.0 for Windows or better
	'or Liberty BASIC v0.6 for OS/2 or better
    'Copyright 1993, Shoptalk Systems
    'All Rights Reserved

    ' set up the board
    dim board$(9)
    dim razz$(9)

    nomainwin

    loadbmp "title", "titlettt.bmp"
    loadbmp "square", "squarttt.bmp"

    WindowWidth = 314
    WindowHeight = 400
    button #brd, " T ", [1], UL, 10, 60
    button #brd, " I ", [2], UL, 110, 60
    button #brd, " C ", [3], UL, 210, 60
    button #brd, " T ", [4], UL, 10, 160
    button #brd, " A ", [5], UL, 110, 160
    button #brd, " C ", [6], UL, 210, 160
    button #brd, " T ", [7], UL, 10, 260
    button #brd, " O ", [8], UL, 110, 260
    button #brd, " E ", [9], UL, 210, 260
    button #brd, "Pass Move", [skipMove], UL, 210, 10
    textbox #brd.comment, 10, 27, 170, 25
    menu #brd, "&Help", "&Instructions", [instruct], "&About Tic Tac Toe", [about]
    open "Tic Tac Toe Playing Board" for graphics_nsb as #brd
    print #brd, "trapclose [quit]";
    print #brd, "size 3 ; down";
    gosub [drawBoard]
    yourName$ = "Human"
    prompt "What is your name?"; yourName$

    razz$(0) = "Boooh! Hisss!"
    razz$(1) = "Oh! I'm Scared!"
    razz$(2) = "No Dur!"
    razz$(3) = "Why that move?"
    razz$(4) = "Lost Cause."
    razz$(5) = "No Hope."
    razz$(6) = "Change Careers."
    razz$(7) = "Major Bummer!"
    razz$(8) = "Boring."
    razz$(9) = "I'm insulted."


[start]    'start game (or restart)

    for x = 1 to 9 : board$(x) = " " : next x
    gosub [modelBoard]
    turn = 0
    true = 1
    false = 0
    pass = false
    comment$ = "Your Turn, " + yourName$
    lastComment$ = ""
    moveCounter = 0
    gosub [comment]

[playLoop]


    input position$

  goto [playLoop]


[move]

    ' X moves
    if board$(val(position$)) <> " " then notice "Illegal Move!" : goto [playLoop]
    moveCounter = moveCounter + 1
    pass = false
    board$(val(position$)) = "X"
    gosub [drawX]
    gosub [modelBoard]
    gosub [checkForWinOrDraw]
    goto [oMoves]

[skipMove]

    pass = true

[oMoves]

    ' O moves
    gosub [computeMove]
    board$(val(position$)) = "O"
    gosub [drawO]
    gosub [modelBoard]
    gosub [checkForWinOrDraw]

  goto [playLoop]


[1]
    position$ = "1" : goto [move]
[2]
    position$ = "2" : goto [move]
[3]
    position$ = "3" : goto [move]
[4]
    position$ = "4" : goto [move]
[5]
    position$ = "5" : goto [move]
[6]
    position$ = "6" : goto [move]
[7]
    position$ = "7" : goto [move]
[8]
    position$ = "8" : goto [move]
[9]
    position$ = "9" : goto [move]

[end]

    end

[drawBoard]

    print #brd, "fill lightgray";
    print #brd, "drawbmp title 7 2";
    for x = 4 to 204 step 100
    for y = 54 to 254 step 100
        print #brd, "drawbmp square "; x; " "; y ;
    next y
    next x
    print #brd, "flush";


[comment]

    if comment$ = "" or comment$ = lastComment$ then return
    print #brd.comment, comment$

  return



[drawX]

    gosub [xlatePosition]
    print #brd, "size 6";
    print #brd, "color darkred";
    print #brd, "line "; squareX-11; " "; squareY-16; " "; squareX+19; " "; squareY+24
    print #brd, "line "; squareX+19; " "; squareY-16; " "; squareX-11; " "; squareY+24
    print #brd, "color red";
    print #brd, "line "; squareX-15; " "; squareY-20; " "; squareX+15; " "; squareY+20
    print #brd, "line "; squareX+15; " "; squareY-20; " "; squareX-15; " "; squareY+20
    print #brd, "flush";

  return


[drawO]

    gosub [xlatePosition]
    print #brd, "size 7";
    print #brd, "color darkblue";
    print #brd, "place "; squareX+5; " "; squareY+5
    print #brd, "circle 20";
    print #brd, "color blue";
    print #brd, "place "; squareX; " "; squareY
    print #brd, "circle 20";
    print #brd, "flush";

  return


[xlatePosition]

    position = val(position$)

    squareX = 55
    if instr("258", position$) > 0 then squareX = 155
    if instr("369", position$) > 0 then squareX = 255

    squareY = int((val(position$)+2)/3)*100+5

  return


[modelBoard]

    row1$ = board$(1)+board$(2)+board$(3)
    row2$ = board$(4)+board$(5)+board$(6)
    row3$ = board$(7)+board$(8)+board$(9)

    col1$ = board$(1)+board$(4)+board$(7)
    col2$ = board$(2)+board$(5)+board$(8)
    col3$ = board$(3)+board$(6)+board$(9)

    diag1$ = board$(1)+board$(5)+board$(9)
    diag2$ = board$(7)+board$(5)+board$(3)

  return



[computeMove]


    ' create some sort of intimidating comment

    newComment$ = razz$(int(rnd(1)*10))
    if comment$ = newComment$ then [computeMove] ' try again
    comment$ = newComment$
    if pass = true then comment$ = "You pass."
    gosub [comment]


    'check for instant win!

[instantWin]

    if moveCounter < 3 then [defend]

    if row1$ = "OO " then position$ = "3" : return
    if row1$ = " OO" then position$ = "1" : return
    if row1$ = "O O" then position$ = "2" : return
    if row2$ = "OO " then position$ = "6" : return
    if row2$ = " OO" then position$ = "4" : return
    if row2$ = "O O" then position$ = "5" : return
    if row3$ = "OO " then position$ = "9" : return
    if row3$ = " OO" then position$ = "7" : return
    if row3$ = "O O" then position$ = "8" : return

    if col1$ = "OO " then position$ = "7" : return
    if col1$ = " OO" then position$ = "1" : return
    if col1$ = "O O" then position$ = "4" : return
    if col2$ = "OO " then position$ = "8" : return
    if col2$ = " OO" then position$ = "2" : return
    if col2$ = "O O" then position$ = "5" : return
    if col3$ = "OO " then position$ = "9" : return
    if col3$ = " OO" then position$ = "3" : return
    if col3$ = "O O" then position$ = "6" : return

    if diag1$ = "OO " then position$ = "9" : return
    if diag1$ = " OO" then position$ = "1" : return
    if diag1$ = "O O" then position$ = "5" : return
    if diag2$ = "OO " then position$ = "3" : return
    if diag2$ = " OO" then position$ = "7" : return
    if diag2$ = "O O" then position$ = "5" : return

[defend]

    'make the purely defensive moves

    if moveCounter = 1 then [attack]

    if row1$ = "XX " then position$ = "3" : return
    if row1$ = " XX" then position$ = "1" : return
    if row1$ = "X X" then position$ = "2" : return
    if row2$ = "XX " then position$ = "6" : return
    if row2$ = " XX" then position$ = "4" : return
    if row2$ = "X X" then position$ = "5" : return
    if row3$ = "XX " then position$ = "9" : return
    if row3$ = " XX" then position$ = "7" : return
    if row3$ = "X X" then position$ = "8" : return

    if col1$ = "XX " then position$ = "7" : return
    if col1$ = " XX" then position$ = "1" : return
    if col1$ = "X X" then position$ = "4" : return
    if col2$ = "XX " then position$ = "8" : return
    if col2$ = " XX" then position$ = "2" : return
    if col2$ = "X X" then position$ = "5" : return
    if col3$ = "XX " then position$ = "9" : return
    if col3$ = " XX" then position$ = "3" : return
    if col3$ = "X X" then position$ = "6" : return

    if diag1$ = "XX " then position$ = "9" : return
    if diag1$ = " XX" then position$ = "1" : return
    if diag1$ = "X X" then position$ = "5" : return
    if diag2$ = "XX " then position$ = "3" : return
    if diag2$ = " XX" then position$ = "7" : return
    if diag2$ = "X X" then position$ = "5" : return


[attack]

    ' now make the offensive moves

    moves$ = ""

    if instr(diag1$,"X") > 0 then [d2]
    if board$(1) = " " then moves$ = moves$ + "1"
    if board$(5) = " " then moves$ = moves$ + "5"
    if board$(9) = " " then moves$ = moves$ + "9"
    i = int(rnd(1)*len(moves$))+1
    position$ = mid$(moves$, i, 1)
    return



[d2]

    if instr(diag2$,"X") > 0 then [moreMoves]
    if board$(7) = " " then moves$ = moves$ + "7"
    if board$(5) = " " then moves$ = moves$ + "5"
    if board$(3) = " " then moves$ = moves$ + "3"
    i = int(rnd(1)*len(moves$))+1
    position$ = mid$(moves$, i, 1)
    return


[moreMoves]

    ' now make random moves

    all$ = row1$ + row2$ + row3$
    blanks$ = ""
    for i = 1 to 9
        if mid$(all$, i, 1) = " " then blanks$ = blanks$ + chr$(48+i)
    next i
    if blanks$ = "" then position$ = "" : return
    i = int(rnd(1)*len(blank$))+1
    position$ = mid$(blanks$, i, 1)
    return

[error]

    notice "Error, no move computed"
    stop


    'check to see if the game has been won or drawn

[checkForWinOrDraw]

    ' check for win
    i$ = ","
    letter$ = "XXX"
    for i = 1 to 2
        if instr(row1$+i$+row2$+i$+row3$, letter$) > 0 then [win]
        if instr(col1$+i$+col2$+i$+col3$, letter$) > 0 then [win]
        if instr(diag1$+i$+diag2$, letter$) > 0 then [win]
        letter$ = "OOO"
    next i

    'check to see if the board is full
    if instr(row1$+row2$+row3$, " ") > 0 then return

    'the game is a draw

    confirm "Draw!  Play again?"; play$
    if play$ = "yes" then print #brd, "cls "; : gosub [drawBoard] : goto [start]
    goto [quit]


[win]

    if letter$ = "OOO" then notice "I WIN!  HA HA HA!"
    if letter$ = "XXX" then notice "You win "; yourName$; "!!!, Bummer!"
    confirm "Play again?"; play$
    if letter$ = "OOO" and play$ = "no" then notice "Sore loser!"
    if play$ = "yes" then print #brd, "cls "; : gosub [drawBoard] : goto [start]


[quit]

    if instructIsOpen = 1 then close #instruct
    close #brd

    end


[instruct]

    WindowHeight = 250
    UpperLeftX = 300
    UpperLeftY = 50

    button #instruct, "OK", [closeInstruct], LR, 5, 5
    open "Tic Tac Toe Instructions" for graphics_nsb as #instruct

    print #instruct, "trapclose [closeInstruct]";

    text$ = "\ "
    text$ = text$ + "\Tic Tac Toe"
    text$ = text$ + "\Copyright 1993, Shoptalk Systems"
    text$ = text$ + "\ "
    text$ = text$ + "\Instructions:"
    text$ = text$ + "\ "
    text$ = text$ + "\  In this game, you play against the"
    text$ = text$ + "\  computer.  You are X, and the computer"
    text$ = text$ + "\  is O.  The one to get 3 in a row wins."
    text$ = text$ + "\  If no one gets three in a row, then"
    text$ = text$ + "\  it is a draw."

    print #instruct, text$
    print #instruct, "flush";

    instructIsOpen = 1

    goto [playLoop]

[closeInstruct]

    close #instruct
    instructIsOpen = 0

    goto [playLoop]


[about]

    notice "About Tic Tac Toe"+chr$(13)+"Tic Tac Toe, A Liberty BASIC program"

    goto [playLoop]
