VERSION 2.00
Begin Form WinSeek 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Dir2DBF"
   ClientHeight    =   3555
   ClientLeft      =   1140
   ClientTop       =   3225
   ClientWidth     =   7080
   ForeColor       =   &H00000080&
   Height          =   3960
   Icon            =   SEEK.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1080
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3555
   ScaleWidth      =   7080
   Top             =   2880
   Width           =   7200
   Begin CommandButton cmdWrite 
      Caption         =   "&Write"
      Enabled         =   0   'False
      Height          =   375
      Left            =   5610
      TabIndex        =   19
      Top             =   720
      Width           =   1335
   End
   Begin SSPanel Panel3D1 
      BevelInner      =   1  'Inset
      Height          =   3555
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   7065
      Begin SSFrame Frame3D1 
         ForeColor       =   &H00000000&
         Height          =   945
         Left            =   5610
         TabIndex        =   17
         Top             =   2280
         Width           =   1335
         Begin SSCheck inclSubs 
            Caption         =   "&Include"
            ForeColor       =   &H00000000&
            Height          =   315
            Left            =   120
            TabIndex        =   15
            Top             =   570
            Width           =   1005
         End
         Begin Label Label4 
            BackStyle       =   0  'Transparent
            Caption         =   "Subdirectories In Search"
            Height          =   555
            Left            =   60
            TabIndex        =   16
            Top             =   120
            Width           =   1245
         End
      End
      Begin TextBox StartDir 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   255
         Left            =   3030
         TabIndex        =   13
         TabStop         =   0   'False
         Text            =   "StartDir"
         Top             =   510
         Width           =   1575
      End
      Begin CommandButton cmdCancel 
         Caption         =   "&Cancel"
         Height          =   375
         Left            =   5610
         TabIndex        =   1
         Top             =   1230
         Width           =   1335
      End
      Begin CommandButton cmdSearch 
         Caption         =   "&Search"
         Height          =   375
         Left            =   5610
         TabIndex        =   0
         Top             =   210
         Width           =   1335
      End
      Begin SSPanel Panel3D6 
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   2
         Height          =   2115
         Left            =   210
         TabIndex        =   10
         Top             =   1140
         Width           =   2520
         Begin FileListBox filList 
            Height          =   1980
            Left            =   60
            TabIndex        =   6
            TabStop         =   0   'False
            Top             =   60
            Width           =   2385
         End
      End
      Begin SSPanel Panel3D5 
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   2
         Height          =   435
         Left            =   210
         TabIndex        =   9
         Top             =   390
         Width           =   2250
         Begin TextBox txtFileSpec 
            Height          =   300
            Left            =   60
            TabIndex        =   3
            Text            =   "*.*"
            Top             =   60
            Width           =   2130
         End
      End
      Begin SSPanel Panel3D4 
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   2
         Height          =   1725
         Left            =   2970
         TabIndex        =   8
         Top             =   750
         Width           =   2535
         Begin DirListBox dirList 
            Height          =   1605
            Left            =   60
            TabIndex        =   4
            Top             =   60
            Width           =   2415
         End
      End
      Begin SSPanel Panel3D3 
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   2
         Height          =   435
         Left            =   2970
         TabIndex        =   7
         Top             =   2820
         Width           =   2535
         Begin DriveListBox drvList 
            Height          =   315
            Left            =   60
            TabIndex        =   5
            Top             =   60
            Width           =   2415
         End
      End
      Begin CommonDialog CMDialog 
         Left            =   4500
         Top             =   1770
      End
      Begin Image Icon 
         Height          =   480
         Left            =   6030
         Picture         =   SEEK.FRX:0302
         Top             =   1800
         Width           =   480
      End
      Begin Label Label5 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Directory Sample"
         Height          =   255
         Left            =   270
         TabIndex        =   18
         Top             =   900
         Width           =   2325
      End
      Begin Label Label3 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Drive:"
         Height          =   225
         Left            =   3030
         TabIndex        =   14
         Top             =   2550
         Width           =   1695
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Start Directory:"
         Height          =   255
         Left            =   3030
         TabIndex        =   12
         Top             =   150
         Width           =   1815
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "File Specification:"
         Height          =   285
         Left            =   270
         TabIndex        =   11
         Top             =   150
         Width           =   2055
      End
   End
End
    Dim About As Integer
    Dim Shift, Alt, Ctrl, Txt

    Const SHIFT_MASK = 1
    Const CTRL_MASK = 2
    Const ALT_MASK = 4

Sub cmdCancel_Click ()
    
    If cmdCancel.Caption = "&Exit" Then Write2File
    Close
    End
    
End Sub

Sub cmdSearch_Click ()
  
  txtFileSpec.SetFocus

  ' Update dirList.Path if it is different from the currently
  ' selected directory, otherwise perform the search.
  If dirList.Path <> dirList.List(dirList.ListIndex) Then
     dirList.Path = dirList.List(dirList.ListIndex)
     Exit Sub         ' Exit so user can take a look before searching.
  End If

  Search
  
  ' Prepare for next search
 
  WinSeek.dirList.Path = CurDir$
  WinSeek.drvList.Drive = WinSeek.dirList.Path ' Reset DOS path.
  WinSeek.filList.Path = WinSeek.dirList.Path
  Abort = False
  WinSeek.cmdCancel.Enabled = True
  WinSeek.cmdWrite.Enabled = True
  WinSeek.cmdSearch.SetFocus

End Sub

Sub cmdWrite_Click ()
    
  Write2File
  
  ' Change Caption of Cancel Button
  WinSeek.cmdCancel.Caption = "&Cancel"
  WinSeek.cmdCancel.Enabled = True

End Sub

Sub DirList_Change ()
    ' Update File listbox to sync with Dir listbox.

On Error GoTo DirHandler
    filList.Path = dirList.Path
    StartDir.Text = dirList.Path

    Exit Sub

DirHandler:
    WinSeek.Show    ' Show Form
    MsgBox "Wrong path entered", , "Error"

End Sub

Sub DirList_LostFocus ()
    dirList.Path = dirList.List(dirList.ListIndex)
End Sub

Sub DrvList_Change ()
    On Error GoTo DriveHandler
    dirList.Path = drvList.Drive
    Exit Sub

DriveHandler:
    WinSeek.Show    ' Show Form
    MsgBox "Wrong drive entered", , "Error"
    drvList.Drive = dirList.Path
    Exit Sub
End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
    
    ShiftKey = (Shift And SHIFT_MASK) > 0
    AltKey = (Shift And ALT_MASK) > 0
    CtrlKey = (Shift And CTRL_MASK) > 0

    If ShiftKey And CtrlKey And AltKey Then
       About = True
    End If

End Sub

Sub Form_KeyUp (KeyCode As Integer, Shift As Integer)
    
       About = False

End Sub

Sub Form_Load ()

    Panel3D1.Move 0, 0
    Panel3D1.Width = WinSeek.ScaleWidth
    Panel3D1.BackColor = WinSeek.BackColor
    txtFileSpec.Text = SearchSpec
    If AutoRunFlag = True Then
	WinSeek.Hide                             ' Hide Main form.
	If IncludeSubs = True Then WinSeek.inclSubs.Value = True
	drvList.Drive = DriveSpec
	dirList.Path = DirSpec
	Search
	Write2File
	Close
	End
    Else
	WinSeek.Show
    End If
    StartDir.Text = dirList.Path

End Sub

Sub Form_Unload (Cancel As Integer)
    
    If cmdCancel.Caption = "&Exit" Then Write2File
    Close
    End

End Sub

Sub Image1_Click ()

If About = True Then
    Msg = "A Directory To dBASEIII-format File translator."
    Msg = Msg & Chr$(13) & Chr$(10)
    Msg = Msg & " Imre Fabian, Almere, Nederland."
    Msg = Msg & Chr$(13) & Chr$(10)
    Msg = Msg & "  Partial CopyRight MicroSoft."
    Title = "AboutBox"
    MsgBox Msg, , Title
End If
    About = False

End Sub

Sub txtFileSpec_Change ()
' Update file list box if user changes pattern.
    filList.Pattern = txtFileSpec.Text
End Sub

Sub txtFileSpec_DblClick ()
    cmdSearch_Click
End Sub

Sub txtFileSpec_GotFocus ()
    txtFileSpec.SelStart = 0      ' Highlight the current entry.
    txtFileSpec.SelLength = Len(txtFileSpec.Text)
End Sub

Sub txtFileSpec_KeyDown (KeyCode As Integer, Shift As Integer)

    If KeyCode = 9 Or KeyCode = 10 Or KeyCode = 13 Then txtFileSpec_DblClick

End Sub

