/* file ffencode.c */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

#define replacechar   ' '
#define char_zero     ' '
#define char_one     0xff
#define tabsize        10
#define i_tfsz       4096
#define i_hfsz       1024
#define i_ofsz       4096
#define ff_startline "ffcode"
#define linesize       64

int tfh = -1, hfh = -1, ofh = -1,
    tfp = -1, hfp = -1, ofp = 0,
    tfsz = 0, hfsz = 0, ofsz = 0,
    hfbpos = 0, startline_pos = 0;
unsigned char *tfbuf = NULL, *hfbuf = NULL, *ofbuf = NULL;


int getchr(void)
{
  int c;

  if (tfsz < 1)
    return -1;
  if (tfp < 0 || tfp >= tfsz)
  {
    tfp = 0;
    tfsz = read(tfh, tfbuf, tfsz);
    if (tfsz < 1)
      return -1;
  }
  c = tfbuf[tfp++];
  return c;
}


int getbit(void)
{
  int c;

  if (hfbpos > 0)
  {
    hfbpos--;
    c = hfbuf[hfp];
    return (c >> hfbpos) & 1;
  }
  else if (hfsz < 1)
    return -1;
  else if (startline_pos >= 0)
  {
    hfp = 0;
    *hfbuf = ff_startline[startline_pos++];
    if (!ff_startline[startline_pos])
      startline_pos = -2;
    hfbpos = 7;
    c = hfbuf[hfp];
    return (c >> hfbpos) & 1;
  }
  hfp++;
  if (hfp < 0 || hfp >= hfsz || startline_pos == -2)
  {
    hfp = 0;
    startline_pos = -1;
    hfsz = read(hfh, hfbuf, hfsz);
    if (hfsz < 1)
      return -1;
  }
  hfbpos = 7;
  c = hfbuf[hfp];
  return (c >> hfbpos) & 1;
}


void outchr(int c)
{
  int i;

  if (c >= 0 && ofp < ofsz)
    ofbuf[ofp++] = c;
  else
  {
    i = write(ofh, ofbuf, ofp);
    ofp = 0;
    if (i < 0)
    {
      printf("bad write, disk full?");
      exit(1);
    }
    if (c >= 0) ofbuf[ofp++] = c;
  }
}


void ffencode(void)
{
  int i, done, c, lpos;

  tfsz = i_tfsz;
  hfsz = i_hfsz;
  ofsz = i_ofsz;
  tfbuf = (unsigned char *)malloc(tfsz);
  hfbuf = (unsigned char *)malloc(hfsz);
  ofbuf = (unsigned char *)malloc(ofsz);
  if (!tfbuf || !hfbuf || !ofbuf)
  {
    printf("not enough memory\n");
    free(tfbuf);
    free(hfbuf);
    free(ofbuf);
    return;
  }
  tfp = hfp = -1;
  ofp = 0;
  hfbpos = 0;
  done = 0;
  lpos = 0;
  startline_pos = 0;

  while (!done)
  {
    c = getchr();
    if (c < 0) done = 1;
    else
    {
      if (c == '\r')
      {
        while (lpos < linesize)
        {
          c = getbit();
          if (c < 0) break;
          outchr(c ? char_one : char_zero);
          lpos++;
        }
        lpos = 0;
        c = '\r';
      }
      else if (c == replacechar)
      {
        c = (getbit() > 0 ? char_one : char_zero);
        lpos++;
      }
      else if (c == 9)
      {
        for (i = 0; i < tabsize; i++)
        {
          c = (getbit() > 0 ? char_one : char_zero);
          if (i < tabsize - 1) outchr(c);
        }
        lpos += tabsize;
      }
      else if (c != '\r' && c != '\n')
        lpos++;
      outchr(c);
    }
  }
  done = 0;
  while (!done)
  {
    c = getbit();
    if (c < 0)
    {
      c = getchr();
      if (c < 0) done = 1;
      else outchr(c);
    }
    else
    {
      if (lpos >= linesize)
      {
        outchr('\r');
        outchr('\n');
        lpos = 0;
      }
      outchr(c > 0 ? char_one : char_zero);
      lpos++;
    }
  }
  if (lpos > 0)
  {
    outchr('\r');
    outchr('\n');
  }
  outchr(-1);
  free(tfbuf);
  free(hfbuf);
  free(ofbuf);
}


int main(int argc, char *argv[])
{
  if (argc != 4)
  {
    printf("ffencode text file / message encryptor\n");
    printf("usage: ffencode textfile hiddenfile outfile\n");
    exit(0);
  }
  
  tfh = open(argv[1], O_BINARY | O_RDONLY);
  if (tfh < 0)
  {
    printf("can't open textfile\n");
    exit(1);
  }

  hfh = open(argv[2], O_BINARY | O_RDONLY);
  if (hfh < 0)
  {
    printf("can't open hiddenfile\n");
    exit(1);
  }

  ofh = open(argv[3], O_BINARY | O_WRONLY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if (ofh < 0)
  {
    printf("can't open outfile\n");
    exit(1);
  }

  ffencode();
  close(tfh);
  close(hfh);
  close(ofh);
  printf("ffencode done\n");
  return 0;
}
