/******************************************************************************
 *		           FREXX PROGRAMMING LANGUAGE    		      *
 ******************************************************************************

 frontend.c

 All frontend functions.

 *****************************************************************************/

/************************************************************************
 *                                                                      *
 * fpl.library - A run time library interpreting script langauge.       *
 * Copyright (C) 1992, 1993 FrexxWare                                   *
 * Author: Daniel Stenberg                                              *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                      *
 * Daniel Stenberg                                                      *
 * Birger Jarlsgatan 93b 3tr                                            *
 * 113 56 Stockholm                                                     *
 * Sweden                                                               *
 *                                                                      *
 * FidoNet 2:201/328      email: dast@sth.frontec.se                    *
 *                                                                      *
 ************************************************************************/

#if defined(AMIGA)
#include <exec/types.h>
#include <proto/exec.h>
#elif defined(UNIX)
#include <sys/types.h>
#endif

#include "script.h"
#include <stdio.h>

#if 0

/************************************************************************
 *
 * fplCallFunction();
 *
 * Calls the specified function with the data found in a standard struct
 * fplArgument!
 *
 ****/

ReturnCode PREFIX fplCallFunction(REG(a0) struct Data *scr,
				  REG(a1) char *funcname,
				  REG(d0) long argc,
				  REG(a2) void **argv,
				  REG(a3) char *format,
				  REG(a4) unsigned long *tags) /* no such yet! */
{
  ReturnCode ret;
  struct Identifier *ident;
  struct fplMsg *msg;
  struct fplStr *string;
  int i=0;
  if(!scr || !funcname || !*funcname || !arg)
    /* prevent a lot of illegal inputs! */
    return(FPL_ILLEGAL_ANCHOR);

  ret=GetIdentifier(scr, funcname, &ident); /* get identifier struct */

  if(!(scr->flags&FPLDATA_ALLFUNCTIONS) && ret)
    return(ret);

  GETMEM(pass, sizeof(struct fplArgument));
  pass->name=funcname;
  pass->ID=ident->data.external.ID;
  pass->funcdata=ident->data.external.data;
  pass->key=scr;
  pass->format=format;

  for(i=0; i<argc; i++) {
    if(UPPER(format[i])==FPL_STRARG) {
      
    }
  }

  CALL(CallFunction(scr, arg, ident)); /* call the function! */

  FREE(pass);

  /* Since we can't receive any return code the proper way, we remove
     all pending return code messages! */

  do {
    GetMessage(scr, FPLMSG_RETURN_INT, &msg);
    if(msg) {
      if(!i++)
	scr->ret=(long)msg->message[0]; /* set return code to first int found */
      DeleteMessage(scr, msg);
    }
  } while(msg);

  do {
    GetMessage(scr, FPLMSG_RETURN_STRING, &msg);
    if(msg) {
      FREE(msg->message[0]); /* delete the returned string! */
      DeleteMessage(scr, msg);
    }
  } while(msg);

  return(FPL_OK);
}

#endif

/***************************************************************************
 *
 * fplGetErrorMsg()
 *
 * Returns a char pointer to an error message to the error given as argument.
 *
 ******/

char * PREFIX fplGetErrorMsg(REG(a0) struct Data *scr,
			     REG(d0) long error,
			     REG(a1) char *buffer)
{
  char len;
  extern const char *errors[];
  if(!scr || !buffer)
    return(NULL);
  strcpy(buffer, errors[(error>FPL_EXIT_OK && error<FPL_UNKNOWN_ERROR)?
			(error-2):(FPL_UNKNOWN_ERROR-1)]);
  len=strlen(buffer);
  if(buffer[len-1]==':') {
    /* Add " <buffer> ", but avoid sprintf() */
    strcat(buffer, " \"");
    strcat(buffer, scr->buf);
    strcat(buffer, "\"");
  }
  strcat(buffer, " error!");
  return(buffer);
}
