**********************************
*                                *
*   powerpacker.library  V36     *
*                                *
*   Release 1.6                  *
*                                *
*   (c) 1991-1003 Nico Franois  *
*                                *
*   example.asm                  *
*                                *
*   This source is public domain *
*   in all respects.             *
*                                *
**********************************

    SECTION "PPexample",CODE

    include "exec/types.i"
    include "exec/funcdef.i"
    include "exec/exec_lib.i"

    include "libraries/ppbase.i"
    include "libraries/powerpacker_lib.i"

Start:
    move.l  ($4).w,a6
    lea     PPName,a1
    moveq   #0,d0
    jsr     _LVOOpenLibrary(a6)     ; open powerpacker.library
    tst.l   d0
    beq.s   EndIt                   ; quit if not available

    move.l  d0,_PPBase              ; store in _PPBase
    move.l  d0,a6

    lea     filename,a0
    moveq   #DECR_POINTER,d0
    moveq   #0,d1
    lea     buffer,a1
    lea     length,a2
    move.l  #0,a3
    jsr     _LVOppLoadData(a6)      ; try to load file 'testfile'
    tst.l   d0
    beq.s   loadok                  ; if zero everything went ok

    * ...                           ; check error code in D0 and react

    bra.s nofree

loadok:

    * ...                           ; file was loaded, so use it

freemem:
    move.l  ($4).w,a6
    move.l  buffer,a1
    move.l  length,d0
    jsr     _LVOFreeMem(a6)         ; free memory allocated by ppLoadData

nofree:
    move.l  ($4).w,a6
    move.l  _PPBase,a1
    jsr     _LVOCloseLibrary(a6)    ; close powerpacker.library
EndIt:
    rts

    SECTION "data",DATA

* library base
_PPBase:        dc.l 0

* strings
filename:       dc.b "testfile",0
PPName:         PPNAME
                cnop 0,2            ; word-align

* buffer position/length
buffer:         dc.l 0
length:         dc.l 0

    END
