(* ------------------------------------------------------------------------
  :Program.       PowerPacker
  :Contents.      Interface to Nico Franois' powerpacker.library
  :Author.        Kai Bolay [kai] (C-Version by Nico Franois)
  :Address.       Hoffmannstrae 168
  :Address.       D-7250 Leonberg 1 (Germany)
  :Address.       UUCP: ...!cbmvax!cbmehq!cbmger!depot1!amokle!kai
  :Address.       FIDO: 2:247/706.3
  :History.       v1.0 [kai] long ago  (translated from C)
  :History.       v1.3 Nico  some time (updated)
  :History.       v1.3 [kai] 22-Nov-91 (bug fixes)
  :History.       v1.3a [kai] 24-Nov-91 (fixed missing exports)
  :History.       v1.3b [kai] 07-Dec-91 (little bugfixes)
  :History.       v1.4 Nico 28-Sep-93 (added ppCrunchBufferDest())
  :Copyright.     Freeware
  :Language.      Oberon
  :Translator.    AMIGA OBERON v2.12e, A+L AG
  :Remark.        Thanks to Nico for his great library
------------------------------------------------------------------------ *)

MODULE PowerPacker;

(*
**      Filename: libraries/PowerPacker.mod
**      Release: 1.3
**
**      (C) Copyright 1991 Nico Franois
**          All Rights Reserved
**
*)

IMPORT
   e: Exec, I: Intuition, d: Dos;
CONST
   PPName* = "powerpacker.library";
   PPVersion* = 35;
   (* decrunch colors for LoadData and DecrunchBuffer *)
   DecrCol0*  = 0;
   DecrCol1*  = 1;
   DecrPoint* = 2;
   DecrScrol* = 3;
   DecrNone*  = 4;
   (* error codes returned by LoadData *)
   LoadOk*    =  0;
   OpenErr*   = -1;
   ReadErr*   = -2;
   NoMemory*  = -3;
   Crypted*   = -4;
   PassErr*   = -5;
   UnknownPP* = -6;
   (* size of speedup buffer *)
   SpeedupBuffLarge*  = 0;
   SpeedupBuffMedium* = 1;
   SpeedupBuffSmall*  = 2;
   (* crunching efficiency *)
   CrunFast*     = 0;
   CrunMediocre* = 1;
   CrunGood*     = 2;
   CrunVeryGood* = 3;
   CrunBest*     = 4;
   (* possible return values from ppCrunchBuffer() and ppCrunchBufferDest() *)
   CrunchAborted*  =  0;
   BufferOverflow* = -1;
TYPE
   PPBase* = STRUCT (libNode* : e.Library);
                flags* : SHORTSET;
                pad* : SHORTINT;
                segList* : e.BPTR;
             END; (* STRUCT *)
   PPBasePtr* = UNTRACED POINTER TO PPBase;
   (** These two function must preserve all Registers an may not deallocate
       their parameters. Stack checking is not allowed! This means:
       "DeallocPars-" and "SaveAllRegs+" and "StackChk-!! **)
   PassFunc* = PROCEDURE (checksum: LONGINT; password: e.ADDRESS): BOOLEAN;
   PercFunc* = PROCEDURE (userdata: e.ADDRESS; totlen: LONGINT;
                          crunlen: LONGINT; lensofar: LONGINT): BOOLEAN;
VAR
   pp* : PPBasePtr;

PROCEDURE LoadData* {pp, -30} (    filename{8}: ARRAY OF CHAR;
                                   col{0}: LONGINT;
                                   memtype{1}: LONGSET;
                               VAR buffer{9}: e.ADDRESS;
                               VAR len{10}: LONGINT;
                                   func{11}: PassFunc): LONGINT;
PROCEDURE DecrunchBuffer* {pp, -36} (endcrun{8},
                                     decrbuf{9},
                                     effptr{10}: e.ADDRESS;
                                     col{0}: LONGINT);
PROCEDURE CalcCheckSum* {pp, -42} (string{8}: ARRAY OF CHAR): INTEGER;
PROCEDURE CalcPasskey* {pp, -48} (password{8}: ARRAY OF CHAR): LONGINT;
PROCEDURE Decrypt* {pp, -54} (buffer{8}: e.ADDRESS;
                              len{0}, key{1}: LONGINT);
PROCEDURE GetPassword* {pp, -60} (screen{8}: I.ScreenPtr;
                                  buffer{9}: e.ADDRESS;
                                  maxchars{0}: LONGINT;
                                  checksum{1}: INTEGER): BOOLEAN;
PROCEDURE AllocCrunchInfo* {pp, -96} (eff{0}: LONGINT;
                                      speedup{1}: LONGINT;
                                      func{8}: PercFunc;
                                      userdata{9}: e.ADDRESS): e.ADDRESS;
PROCEDURE FreeCrunchInfo* {pp, -102} (crunchinfo{8}: e.ADDRESS);
PROCEDURE CrunchBuffer* {pp, -108} (crunchinfo{8}: e.ADDRESS;
                                    buffer{9}: e.ADDRESS;
                                    len{0}: LONGINT): LONGINT;
PROCEDURE WriteDataHeader* {pp, -114} (handle{0}: d.FileHandlePtr;
                                       eff{1}: LONGINT;
                                       crypt{2}: BOOLEAN;
                                       checksum{3}: LONGINT): BOOLEAN;
PROCEDURE EnterPassword* {pp, -120} (screen{8}: I.ScreenPtr;
                                     buffer{9}: e.ADDRESS): BOOLEAN;
PROCEDURE ErrorMessage* {pp, -132} (error{0}: LONGINT): e.STRPTR;
PROCEDURE CrunchBufferDest* {pp, -138} (crunchinfo{8}: e.ADDRESS;
                                        buffer{9}: e.ADDRESS;
                                        dest{10}: e.ADDRESS;
                                        len{0}: LONGINT): LONGINT;

BEGIN
   pp := e.OpenLibrary (PPName, PPVersion);
   IF pp = NIL THEN
      IF I.DisplayAlert (I.recoveryAlert,
           "\x00\x64\x14missing powerpacker.library V35\o\o", 50) THEN END;
      HALT (20)
   END; (* IF *)
CLOSE
   IF pp # NIL THEN
      e.CloseLibrary (pp);
      pp := NIL;
   END; (* IF *)
END PowerPacker.
