#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <errno.h>
#include "wprint.h"

typedef void FAR PASCAL FNDEVICEMODE (HWND,HANDLE,LPSTR,LPSTR);
typedef FNDEVICEMODE FAR * LPFNDEVICEMODE;

static char szPrinter [80], 
            szDriverFile[16], 
            szDeviceName[36], 
            szOutputPort[10];


BOOL FAREXPORT INIDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
BOOL ShowPSBox (HWND);
void SetPrinterText (HWND);
char szMagnifyBy[16];
static int  nScaling;

switch (message) {
    case WM_INITDIALOG:
        SetPrinterText (hDlg);
        nScaling = GetProfileInt ((LPSTR)"WinPrint\0",
                                  (LPSTR)"Scale\0",
                                  (int)-1) - 1;
        GetProfileString ((LPSTR)"WinPrint\0",        
                          (LPSTR)"MagnifyBy\0",
                          (LPSTR)"\0",
                          (LPSTR)szMagnifyBy,
                          sizeof (szMagnifyBy));

        if (nScaling < 0) nScaling = 1;
        
        CheckRadioButton (hDlg,IDD_FIT,IDD_MAG_BY,IDD_FIT+nScaling);
        SetDlgItemText (hDlg, IDD_MAG_VALUE, (LPSTR)szMagnifyBy);
        
        if (nScaling!=2)
            EnableWindow (GetDlgItem(hDlg,IDD_MAG_VALUE),FALSE);
        
        CenterWindow (hDlg);
        return (TRUE);

    case WM_COMMAND:
        
        if (wParam == IDOK){
            char szint [16];
            BOOL bTranslate;

            itoa (nScaling+1,szint, 10); // makes the value 1, 2, or 3
            
            WriteProfileString ((LPSTR)"WinPrint\0",
                                (LPSTR)"Scale\0",
                                (LPSTR)szint);
            
            if (nScaling == MAGNIFY){
                // Let's make sure the magnitude is valid...
                if (!GetDlgItemInt(hDlg, IDD_MAG_VALUE, &bTranslate, FALSE)
                    || !bTranslate){
                    MessageBox (NULL,"\"Magnify By\" must be a number greater than zero",
                                "Error", MB_OK|MB_TASKMODAL);
                    break;
                }
                // Get the value as text and write it...
                GetDlgItemText (hDlg, IDD_MAG_VALUE, (LPSTR)szint, 16);
                
                WriteProfileString ((LPSTR)"WinPrint\0",
                                    (LPSTR)"MagnifyBy\0",
                                    (LPSTR)szint);
            }            
            
            EndDialog (hDlg, TRUE);
        }    
        
        if (wParam == IDCANCEL)
            EndDialog (hDlg, FALSE);
        
        if (wParam == IDPRINTSETUP)
            if (!ShowPSBox (hDlg))
                Error (IDS_DRIVERERROR);
        
        if (wParam == IDD_FIT ||
            wParam == IDD_PRN_RES ||
            wParam == IDD_MAG_BY){
            nScaling = wParam - IDD_FIT;
            if (nScaling==2)
                EnableWindow (GetDlgItem(hDlg,IDD_MAG_VALUE),TRUE);
            else
                EnableWindow (GetDlgItem(hDlg,IDD_MAG_VALUE),FALSE);
        }

        return TRUE;
    default:
        break ;
}
return FALSE;
}

BOOL ShowPSBox (HWND hDlg)
{
HANDLE hLib;
LPFNDEVICEMODE lpfnDeviceMode;
BOOL bResult=FALSE;

// SetPrinterText() set the driver filename up...
hLib = LoadLibrary (szDriverFile);

if (hLib < 32) return bResult;

lpfnDeviceMode = (LPFNDEVICEMODE) GetProcAddress(hLib,"DeviceMode");

if (lpfnDeviceMode != NULL){
    lpfnDeviceMode (hDlg, hLib, szDeviceName, szOutputPort);
    bResult = TRUE;
}
else bResult = FALSE;

FreeLibrary (hLib);

if (bResult) 
    PostMessage ((HWND)0xFFFF, WM_WININICHANGE, 0, (LONG)NULL);

return bResult;
}


void SetPrinterText (HWND hDlg)
{
char *szDevice, *szDriver, *szOutput;

if (!GetProfileString ((LPSTR)"windows\0",
                  (LPSTR)"device\0",
                  (LPSTR)",,,\0", 
                  (LPSTR)szPrinter, 80))
    return;

if ((szDevice = strtok (szPrinter, ",")) &&
    (szDriver = strtok (NULL,      ",")) &&
    (szOutput = strtok (NULL,      ","))){
    lstrcpy ((LPSTR)szDriverFile, szDriver);
    lstrcat ((LPSTR)szDriverFile, (LPSTR)".DRV\0");
    lstrcpy ((LPSTR)szDeviceName,(LPSTR)szDevice);
    lstrcpy ((LPSTR)szOutputPort,(LPSTR)szOutput);
    wsprintf ((LPSTR)szPrinter,"%s on %s",(LPSTR)szDevice, (LPSTR)szOutput);
    SetDlgItemText (hDlg, IDD_CUR_PRINTER, (LPSTR)szPrinter);
}
return; 
}

