#include <commdlg.h>

// Menu item constant identifiers...
#define IDM_ABOUT               100
#define IDM_EXIT                101
#define IDM_FLUSH               102
#define IDM_SETTINGS            103
#define IDM_PRINT               104

// Stringtable constant identifiers...
#define IDS_CLOCKS              200
#define IDS_INSTANCE            201
#define IDS_FILTER              202
#define IDS_EXTENSION           203
#define IDS_NOALLOC             204
#define IDS_NOLOCK              205
#define IDS_NOFORMAT            206
#define IDS_NOPRINT             207
#define IDS_WININI              208
#define IDS_ERRORBM             209
#define IDS_DRIVERERROR         210

// Dialog box constant identifiers...
#define IDD_FLUSHWARN           301
#define IDD_TEMPDIR             302
#define IDD_FILETYPE            303
#define IDD_FILENAME            304
#define IDD_FIT                 305
#define IDD_PRN_RES             306
#define IDD_MAG_BY              307
#define IDD_MAG_VALUE           308
#define IDD_CUR_PRINTER         309
#define IDPRINTSETUP            310

    

// Miscellaneous constants
#define FILE_NAME_SIZE          144
#define FIT_TO_X                0
#define PRINTER_RES             1
#define MAGNIFY                 2
#define WINDOW_EXTENT           100
#define SIZE                    144
#define HourGlass(xx)           SetCursor (LoadCursor(NULL,xx?IDC_WAIT:IDC_ARROW))
#define FAREXPORT               FAR _export PASCAL    // dont have to put
                                                      // function in .def file.
#define KILLOFF (xx)            GlobalUnlock(xx); GlobalFree(xx)

// Type Definitions
typedef struct tagDRAGLIST{
    char szFileName[SIZE];
    } DRAGLIST, FAR * LPDRAGLIST;

typedef BOOL (FAR PASCAL * ABORTPROC) (HDC, short);


// Prototype definitions for main functions...
extern int PASCAL               WinMain(HANDLE, HANDLE, LPSTR, int);
extern BOOL                     InitApplication(HANDLE);
extern BOOL                     InitInstance(HANDLE, int);
extern long FAREXPORT           MainWndProc(HWND, unsigned, WORD, LONG);
extern BOOL FAREXPORT           About(HWND, unsigned, WORD, LONG);
extern BOOL FAREXPORT           INIDlgProc (HWND, unsigned, WORD, LONG);
extern VOID                     CenterWindow (HANDLE) ;
extern BOOL                     Error (int);

// PRINT.C
extern BOOL                     PrintDragList (void);
extern BOOL FAREXPORT           PrintDlgProc (HWND, unsigned, WORD, LONG);
extern BOOL FAREXPORT           AbortProc (HDC, short);
extern HDC                      GetPrinterDC (void);  // I want this local...
extern BOOL                     PrintTextFile (char *);
extern BOOL                     PrintBitmap (char *, HBITMAP);
extern BOOL                     FileIsText (char *);
extern BOOL                     FileIsBitmap (char *);
extern HANDLE                   AttemptOpeningDIB (LPSTR);
extern BOOL                     DrawBitmap (HDC, int, int, int, int, HANDLE);
extern DWORD                    GetDIBDimensions (HANDLE);


// DIB.C
extern WORD                     PaletteSize (VOID FAR *);
extern WORD                     DibNumColors (VOID FAR *);
extern BOOL                     DibInfo (HANDLE,LPBITMAPINFOHEADER);
extern HANDLE                   ReadDibBitmapInfo (int);
extern DWORD PASCAL             bigread (int, VOID far *, DWORD);


// external variables...

extern RECT                     rect ;
extern HANDLE                   hInst, hAccel;
extern HWND                     hWndParent,hDlgPrint;
extern char                     szDropFile [SIZE] ;
extern int                      i;
extern WORD                     wNumDrop;
extern HANDLE                   hDragList;
extern LPDRAGLIST               lpDragList;
extern BOOL                     bUserAbort;
extern ABORTPROC                lpfnAbortProc;
extern HDC                      hDCPrn;

/* Common Dialogs stuff */
extern OPENFILENAME             eofn;
extern char                     eszDirName[144] ;
extern char                     eszFile[144], eszFileTitle[144];
extern char *                   eszFilter[17] ; 
