#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <errno.h>
#include <fcntl.h>
#include "wprint.h"

static int nScaleMode, nMagnifyBy;


BOOL PrintDragList (void)
{
BOOL result = FALSE;
char szfilename[144];
HANDLE hDIB;
FARPROC lp = MakeProcInstance(PrintDlgProc, hInst);

hDlgPrint = CreateDialog (hInst, "PRINTBOX", hWndParent, lp);

nScaleMode = GetProfileInt ((LPSTR)"WinPrint\0",(LPSTR)"Scale\0",-1)-1;
nMagnifyBy = GetProfileInt ((LPSTR)"WinPrint\0",(LPSTR)"MagnifyBy\0",-1);

if (nScaleMode < 0 || nMagnifyBy < 0)
	Error(IDS_WININI);

for ( i=0 ; i < (int)wNumDrop ; i++ ){

	lstrcpy ((LPSTR)szfilename, (LPSTR)lpDragList[i].szFileName);

	SetDlgItemText (hDlgPrint, IDD_FILENAME,szfilename);        

	hDIB = AttemptOpeningDIB (szfilename);
	
	SetDlgItemText (hDlgPrint, IDD_FILETYPE, (LPSTR)(hDIB == NULL ?
									   "Text File\0" : "Bitmap File\0"));
	
	result = ((hDIB == NULL) ? PrintTextFile (szfilename) : 
							   PrintBitmap (szfilename,hDIB));

	if (result) Error(IDS_NOPRINT) ;
} // end of for loop...

DestroyWindow (hDlgPrint);

FreeProcInstance (lp);

return !result;
}


/////////////////////////////////////////////////////////////////////////
//
//  PrintDlgProc()
//
//  hDlg - handle to dialog box window
//  message - message param containing sent message number
//  wParam - extra information word for message parameter.
//  lParam - extra information dword for message parameter.
//
/////////////////////////////////////////////////////////////////////////

BOOL FAREXPORT PrintDlgProc(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
switch (message) {

	case WM_INITDIALOG:
		CenterWindow (hDlg);
		EnableMenuItem (GetSystemMenu(hDlg, FALSE), SC_CLOSE, MF_GRAYED);
		return (TRUE);

	case WM_COMMAND:
		bUserAbort = TRUE;
		EnableWindow (GetParent(hDlg), TRUE);
		DestroyWindow (hDlg);
		hDlgPrint = 0;
		return TRUE;

}
return FALSE;
}

/////////////////////////////////////////////////////////////////////////
//
//  AbortProc()
//
//  hdcPrn - Printer Device Context...
//  nCode  - Error code passed to AbortProc by Escape...
//
/////////////////////////////////////////////////////////////////////////
BOOL FAREXPORT AbortProc (HDC hdcPrn, short nCode)
{
MSG msg;

while (!bUserAbort && PeekMessage (&msg,NULL,0,0,PM_REMOVE)){
	if (!hDlgPrint || !IsDialogMessage (hDlgPrint, &msg)){
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}
}

return !bUserAbort;
}

/////////////////////////////////////////////////////////////////////////
//
//  PrintTextFile()
//
//  filename - Name of file to print.
//
/////////////////////////////////////////////////////////////////////////
BOOL PrintTextFile (char * filename)
{
BOOL bError = FALSE;
HDC hdcPrn;
char szMessage[128];
TEXTMETRIC tm;
short dy, charsPerLine, linesPerPage, xMargin, yMargin;

if (NULL == (hdcPrn = GetPrinterDC ()))
	return TRUE;

bUserAbort = FALSE;

GetTextMetrics (hdcPrn, &tm);

// margins (multiplied by 2). Half inch horizontal and inch vertical margins.
xMargin = GetDeviceCaps (hdcPrn, LOGPIXELSX) ;
yMargin = 2*GetDeviceCaps (hdcPrn, LOGPIXELSY) ;

// Allow for half-inch horizontal margins...
charsPerLine = (GetDeviceCaps (hdcPrn, HORZRES) - xMargin)/tm.tmAveCharWidth ;

dy = tm.tmHeight + tm.tmExternalLeading;

linesPerPage = (GetDeviceCaps (hdcPrn, VERTRES) - yMargin) / dy;

// safeguard in case lines run greater than 128 chars (size of buffer)...
if (charsPerLine > 128) charsPerLine = 128 ;

EnableWindow (hWndParent, FALSE);  // wouldn't want someone to drag another
								   // file while printing.

lpfnAbortProc = MakeProcInstance (AbortProc, hInst);
Escape (hdcPrn, SETABORTPROC, 0, (LPSTR) lpfnAbortProc, NULL);

sprintf (szMessage, "Printing: %s", filename);   // for print manager


if (Escape (hdcPrn, STARTDOC, sizeof (szMessage)-1, szMessage, NULL) > 0){
	FILE * file = fopen (filename, "r+t");
	char szBuffer [128];
	int nLine=0;
		
	if (file==NULL) bError = TRUE ; 

	/* read in the maximum amount of characters per line */

	while (fgets(szBuffer, charsPerLine, file) != NULL){

		szBuffer[strlen(szBuffer)-1] = '\0';  // get rid of '\n' in printout.

		TextOut (hdcPrn, xMargin/2, 
				 dy*nLine + (yMargin/2),(LPSTR)szBuffer, strlen(szBuffer));

		nLine++ ;    // increment line counter...

		if (nLine > linesPerPage){
			if (Escape (hdcPrn, NEWFRAME, 0, NULL, (LPSTR)&rect) < 0){
				bError = TRUE;
				break ;
			}
			if (bUserAbort) break ;
			nLine = 0 ;   // reset the line counter because new page...
		}
	}  // end of while statement...

	// This processes the page that did not go to the end of the page.
	if (Escape (hdcPrn, NEWFRAME, 0, NULL, (LPSTR)&rect) < 0)
		bError = TRUE;

	if (fclose (file))
		MessageBox (NULL, "File was not closed successfully","Error",MB_OK|MB_TASKMODAL);
}
else
	bError = TRUE;

if (!bError) Escape (hdcPrn, ENDDOC, 0, NULL, NULL) ;   // end print job...

/******   Assuming everything went OK, we're done printing...  ******/

if (!bUserAbort)
	EnableWindow (hWndParent, TRUE);


FreeProcInstance (lpfnAbortProc);
DeleteDC (hdcPrn);

return bError || bUserAbort;
}


////////////////////////////////////////////////////////////////////////
// 
// 
//  PrintBitmap() 
// 
//  Prints a bitmap file using the banding logic. 
// 
//  filename  - string containing name of bitmap file. 
//  hDIB - A memory handle to DIB. 
// 
////////////////////////////////////////////////////////////////////////
 
 
BOOL PrintBitmap (char * filename, HANDLE hDIB) 
{ 
// Unitialized local variables : 
char    szMessage[128]; 
int     dx, dy, xRes, yRes, xSize, ySize; 
RECT   Rect; 
// Initialized local variables : 
LONG   lDIBDims   = GetDIBDimensions (hDIB); 
HDC     hdcPrn     = GetPrinterDC(); 
BOOL    bError     = FALSE; 
 
	if (!hdcPrn) return TRUE; 
 
	EnableWindow (hWndParent, FALSE); 
 
	bUserAbort = FALSE; 
 
	/* Make a procedure instance of the exported AbortProc() and donate it 
	   to the GDI */ 
	lpfnAbortProc = MakeProcInstance (AbortProc, hInst); 
	Escape (hdcPrn, SETABORTPROC, 0, (LPSTR) lpfnAbortProc, NULL); 
 
	xSize = GetDeviceCaps(hdcPrn, HORZRES); 
	ySize = GetDeviceCaps(hdcPrn, VERTRES); 
	xRes  = GetDeviceCaps(hdcPrn, LOGPIXELSX); 
	yRes  = GetDeviceCaps(hdcPrn, LOGPIXELSY); 
		 
	switch (nScaleMode){
		case FIT_TO_X:  // case mode is fit to page...
			dx = xSize - xRes; 
			dy = (int)((LONG)dx * HIWORD(lDIBDims)/LOWORD(lDIBDims)); 

			/* Fix bounding rectangle for the picture .. */ 
			SetRect (&Rect, xRes/2, yRes, dx, dy);
			break;

		case PRINTER_RES:  // case mode is printer resolution...
			SetRect (&Rect, xRes/2, yRes, LOWORD(lDIBDims),
					 HIWORD(lDIBDims));
			break;

		case MAGNIFY:  // case mode is scale by a magnification amount...
			SetRect (&Rect, xRes/2, yRes, 
					 LOWORD(lDIBDims) * nMagnifyBy,
					 HIWORD(lDIBDims) * nMagnifyBy);
			break;            

		default:
			FreeProcInstance (lpfnAbortProc);
			DeleteDC (hdcPrn);
			return TRUE;
	} 
	
	wsprintf ((LPSTR)szMessage, "Printing: %s", (LPSTR)filename); 
 
	if (Escape (hdcPrn, STARTDOC, sizeof (szMessage)-1, szMessage, NULL) > 0){ 
		RECT BandRect; 
 
		Escape (hdcPrn, NEXTBAND, 0, (LPSTR)NULL, (LPSTR)&BandRect); 
 
		while (!IsRectEmpty(&BandRect) && !bUserAbort){ 
 
			DPtoLP  (hdcPrn,(LPPOINT)&BandRect,2); 
 
			(* lpfnAbortProc) (hdcPrn, 0);  /* let AbortProc do a check */ 

			
			if (!DrawBitmap (hdcPrn, Rect.left,Rect.top,  
				 Rect.right,Rect.bottom, hDIB)) 
				 Error(IDS_ERRORBM);     

			/* find out the dimensions of the next band */         
			Escape (hdcPrn, NEXTBAND, 0, (LPSTR)NULL, (LPSTR)&BandRect); 
		} 
	}  
	else 
		bError = TRUE; 
 
	/* Tell GDI to tell the device driver that we are done with the print 
	   job */ 
	if (!bError) Escape (hdcPrn, ENDDOC, 0, NULL, NULL) ; 
 
	if (!bUserAbort) 
		EnableWindow (hWndParent, TRUE); 
 
	FreeProcInstance (lpfnAbortProc); 
 
	DeleteDC (hdcPrn); 
 
	return bError || bUserAbort; 
} 


HDC GetPrinterDC (void)
{
static char szPrinter [80];
char *szDevice, *szDriver, *szOutput;

GetProfileString ("windows", "device", ",,,", szPrinter, 80);

if ((szDevice = strtok (szPrinter, ",")) &&
	(szDriver = strtok (NULL,      ",")) &&
	(szOutput = strtok (NULL,      ",")))
		return CreateDC (szDriver, szDevice, szOutput, NULL);
 
return NULL;
}


DWORD GetDIBDimensions (HANDLE hdib)
{
LPBITMAPINFOHEADER lpdib;
DWORD dwResult;

lpdib = (LPBITMAPINFOHEADER) GlobalLock (hdib);

if (!lpdib) return 0L;

dwResult = (DWORD) MAKELONG (lpdib->biWidth, lpdib->biHeight);

GlobalUnlock (hdib);

return  dwResult;
}


BOOL DrawBitmap(hDC,x,y,dx,dy,hDIB)
HDC      hDC;
int      x,y,dx,dy;
HANDLE   hDIB;
{
  BOOL               bSuccess=TRUE;
  LPSTR              pBuf;
  LPBITMAPINFOHEADER lpbi;
  DWORD              dDims = GetDIBDimensions (hDIB);

	if (NULL == ( lpbi=(VOID FAR *)GlobalLock(hDIB) ) )
		return FALSE;

	pBuf = (LPSTR)lpbi + (WORD)lpbi->biSize + PaletteSize(lpbi);

	bSuccess = StretchDIBits ( hDC,
			x, y,
			dx, dy,
			0, 0,
			LOWORD(dDims),HIWORD(dDims),
			pBuf, (LPBITMAPINFO)lpbi,
			DIB_RGB_COLORS,
			SRCCOPY);             

  GlobalUnlock (hDIB);

  return bSuccess ;
}
