/* cdrom.h: */

#ifndef _CDROM_H_
#define _CDROM_H_

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/io.h>
#include <devices/scsidisk.h>

#define VERSION "1.0 (12.09.93)"

#define SCSI_BUFSIZE 2048

#define SCSI_BUFFERS 10

typedef struct CDROM {
  unsigned char 	*buffer;
  unsigned char		*buffers[SCSI_BUFFERS];
  unsigned char		sense[20];
  long 			current_sectors[SCSI_BUFFERS];
  struct MsgPort 	*port;
  struct IOStdReq	*scsireq;
  struct SCSICmd	cmd;
} CDROM;

CDROM *Open_CDROM (char *p_device, int p_scsi_id);
int Read_Sector (CDROM *p_cd, long p_sector);
int Read_Sector_With_Lookahead (CDROM *p_cd, long p_sector,
			        long p_last_sector);
void Cleanup_CDROM (CDROM *p_cd);
int Test_Unit_Ready (CDROM *p_cd);

#endif /* _CDROM_H_ */
