/*
 * File......: GPTRSTA.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"

#define GETPRINTERSTAT  224      /* E0h */

/*  $DOC$
 *  $FUNCNAME$
 *     fn_gPtrSta()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Get Status of Specified File Server Printer
 *  $SYNTAX$
 *
 *     aFlags := fn_gPtrSta(nPtrNum)
 *
 *  $ARGUMENTS$
 *
 *     <nPtrNum> is the File Server Printer Number you are requesting the
 *               status of.
 *
 *  $RETURNS$
 *
 *      <aFlags> is an array containing four elements as follows:
 *
 *         aFlags[1] : Printer Halted flag (logical)
 *         aFlags[2] : Printer Offline flag (logical)
 *         aFlags[3] : Form Type (0-255)
 *         aFlags[4] : Target Printer Number (0-4)
 *
 *     If the call was successful (printer number exists) the flags will be
 *     set accordingly, otherwise an empty array is returned.
 *
 *  $DESCRIPTION$
 *
 *  This function returns the status of the specified file server printer.
 *  The information returned in the reply packet holds the following 
 *  information:
 *
 *    Printer Halted:   indicates that the printer was stopped from the
 *                      print console (logical)
 *    Printer Offline:  indicates whether the specified printer off- or
 *                      on- line (logical)
 *    Form Type:        indicates which of the 256 forms is in use
 *    Target Printer:   indicates the printer number. This will only
 *                      be different from the specified printer if the
 *                      printer has been re-routed by the network.
 *
 *
 *   Author's note:  This documentation was written by Chris Shortt.
 *
 *  $EXAMPLES$
 *
 *      function main()
 *
 *         local   aResult:={}
 *         aResult := fn_gPtrSta(0)
 *      return NIL
 *
 *  $SEEALSO$
 *
 *  $END$
 */


function fn_gPtrSta( nPtr )
  local cReq, cRep, aRep := {}
  
  default nPtr to 0

  cReq := I2BYTE( 6 ) + I2BYTE( nPtr )
  cRep := repl( chr(0), 4 )

  if _fnReq( GETPRINTERSTAT, cReq, @cRep ) == 0
      aRep := {  !( BYTE2I( left( cRep,1 ) ) == 0 ),;         // Halted?
                 !( BYTE2I( substr( cRep, 2, 1 ) ) == 0 ),;   // Offline?
                 BYTE2I( substr( cRep, 3, 1 ) ),;             // Form type
                 BYTE2I( right( cRep, 1 ) ) ;                 // Target ptr #
              }
  endif

  return aRep

     





