/*
 * File......: BROADMSG.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_SBM()
 *  $CATEGORY$
 *     Message
 *  $ONELINER$
 *     Send broadcast message
 *  $SYNTAX$
 *
 *     fn_sbm( <anConn>, <cMsg> ) -> aResult
 *
 *  $ARGUMENTS$
 *
 *     <anConn> is an array of numeric connection IDs (e.g., 1-100 in 
 *     NW 286, 1-250 in NW386).  If you only want to send to one 
 *     connection ID, just send in a one element array, i.e. { nConn }
 *
 *  $RETURNS$
 *
 *     An array of result codes as follows:
 *
 *          0        Success (msg stored in target msg buffer)
 *        252        Rejected (target station buffer full)
 *        253        Invalid Connection Number (too high, etc)
 *        255        Blocked (station casted off, or isn't in use)
 *
 *  $DESCRIPTION$
 *
 *     fn_sbm() sends a broadcast message to the specified logical
 *     connections on the default file server.
 *
 *     Note that a broadcast message on Novell Netware does *not*
 *     contain the userid/connection number of the sender.
 *     It will show up on line 25 of the user's screen, with only 
 *     the symbol  ">>" in front of it.
 *
 *     A broadcast message can be up to 55 bytes long.  Workstations
 *     have one 55-byte buffer available.
 *
 *  $EXAMPLES$
 *
 *         aResult := fn_sbm( { 10, 15, 22 } , "Hi there!" )
 *
 *         Attempts to send msg to stations 10, 15, and 22.
 *         Result codes in aResult (array).
 *
 *  $INCLUDE$
 *
 *  $SEEALSO$
 *
 *  $END$
 */


function fn_sbm( aConns, cMsg )
   local cReq, cRep, aRes := {}, nX

   cReq := I2BYTE( 0 ) + ;
           I2BYTE( len( aConns ) ) 

   aeval( aConns, { |x| cReq += I2BYTE( x ) } )

   cReq += I2BYTE( len( cMsg ) ) +;
           cMsg

   cRep := I2BYTE( 0 ) + repl( chr(0), len( aConns ) )

   if _fnReq( 225, cReq, @cRep ) == 0
      for nX := 1 to BYTE2I( substr( cRep, 1, 1 ) )
         aadd( aRes, BYTE2I( subst( cRep, nX + 1, 1 ) ) )
      next
   endif

   return aRes


/*  $DOC$
 *  $FUNCNAME$
 *     FN_GBM()
 *  $CATEGORY$
 *     Message
 *  $ONELINER$
 *     Get broadcast message
 *  $SYNTAX$
 *
 *     fn_gbm() -> aRes
 *
 *  $ARGUMENTS$
 *     
 *     None
 *
 *  $RETURNS$
 *
 *    <aRes>, an array, as follows:
 *
 *          aRes[1] is the result code, a numeric
 *          aRes[2] is the message (if any), a character string
 *
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $INCLUDE$
 *     FTINT86.CH
 *  $SEEALSO$
 *     FT_INT86()
 *  $END$
 */


function fn_gbm()
   local cReq, cRep, aRes, nRet

   cReq := I2BYTE( 1 )
   cRep := space( 56 )

   nRet := _fnReq( 225, cReq, @cRep )
   if nRet == 0
      aRes := { nRet, subs( cRep, 2 ) }
   else
      aRes := { nRet, "" }
   endif

   return aRes








