/*
 * File......: VOLNUM.PRG
 * Author....: David A. Minter
 * CIS ID....: 76247,3475
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by David Minter and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_VOLNUM()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get the volume number given the volume name.
 *  $SYNTAX$
 *
 *     fn_volNum( <cVolName> ) -> <nVolNum>
 *
 *  $ARGUMENTS$
 *
 *     <cVolName> is the name of the Server Volume with no colon at the
 *                end.
 *
 *  $RETURNS$
 *
 *		 <nVolNumber> is the volume number.  If the number is negative,
 *       there was an error (check with fn_error() )
 *
 *  $DESCRIPTION$
 *
 *		 This function determines a volume's number given its name.
 *
 *  $EXAMPLES$
 *
 *      function main( cVol )
 *         local nVol := fn_volNum( cVol )
 *         return qout( iif( nVol < 0, "Error: " + str( fn_error() ), nVol ) )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#ifdef FT_TEST

  function main( cVol )
     local nVol := fn_volNum( cVol )
     return qout( iif( nVol < 0, "Error: " + str( fn_error() ), nVol ) )

#endif

function fn_volNum( cVol )
  local cReq, cRep, nResult := -1

	cReq := I2BYTE( 5 ) + I2BYTE( len( cVol ) ) + upper( cVol )
  cRep := " "

	if ( _fnReq( 226, cReq, @cRep ) == ESUCCESS )
     nResult := BYTE2I( cRep )
  endif

  return nResult
