/*
 * File......: ISSUPEQ.PRG
 * Author....: Rodgers Moore
 * CIS ID....: 75730,2244
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Rodgers Moore and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_ISSUPEQ()
 *  $CATEGORY$
 *      Bindery
 *  $ONELINER$
 *      Determine if connection/user is SUPERVISOR-equivalent
 *  $SYNTAX$
 *
 *      fn_IsSupEq( [ <nConn> | <cUserName> ] ) -> lSuper_Equal
 *
 *  $ARGUMENTS$
 *
 *      <nConn> a numeric logical connection number of a station.
 *        .or.
 *      <cUserName> a character user name of a user.
 *      If ommited defaults to the user of the current station.
 *
 *  $RETURNS$
 *
 *      If a connection number is passed as the argument:
 *
 *        Returns .T. if the user logged in at that station has Supervisor
 *        equivalence, .F. if they do not.
 *
 *      If a user name is passed as the argument:
 *
 *        Returns .T. if the user is a Supervisor equivalent
 *                .F. if they are not.
 *
 *  $DESCRIPTION$
 *
 *      This is a high-level wrapper of fn_bndoins() which tests for
 *      Supervisor Equvalence.
 *     
 *  $EXAMPLES$
 *
 *      qout( fn_whoami(5)+" is "+if(fn_IsSupEq(5),"","not ")+"a Supervisor." )
 *
 *      qout( "Joe is "+if(fn_IsSupEq("JOE"),"","not ")+"a Supervisor." )
 *
 *  $SEEALSO$
 *     fn_bndoins()
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_IsSupEq( Para1 )             //  NETWARE SUPERVISOR EQUIVALENCE
   local objname, ;
         supr_name   := fn_bndonam(1,OT_USER)    // GET SUPERVISOR'S USER NAME

   do case
      case valtype(Para1) = 'N'
         objname = fn_whoami(Para1)
      case valtype(Para1) = 'C'
         objname = Para1
      otherwise
         objname = fn_whoami()
   endcase

   if empty(objname)
      return(.F.)
   endif

   return  fn_BndOInS( objname, OT_USER, "SECURITY_EQUALS", supr_name, OT_USER )

