/*
 * File......: DVOLNM.PRG
 * Author....: Michael A. Cohen
 * CIS ID....: 72007,2765
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Michael Cohen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_DvolName()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get the Volume name for a drive letter
 *  $SYNTAX$
 *
 *     fn_DvolName( <cDrive> ) -> <cVolname>
 *
 *  $ARGUMENTS$
 *
 *     <cDrive> corresponds to a drive letter.
 *
 *  $RETURNS$
 *
 *     <cVolname> returns a character volume name (without colon).
 *
 *  $DESCRIPTION$
 *
 *     This call returns the volumne name for a drive letter.
 *
 *  $EXAMPLES$
 *       function main( cDrive )
 *
 *          local cVolname
 *
 *          cVolname := fn_DvolName( cDrive )
 *
 *       return(NIL)
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#ifdef FT_TEST
   external doserror
   function main( cDrive )
     if !empty(cDrive)
        ?  fn_DvolName( cDrive )
      else
        ? "Need to specify a drive letter"
     endif
   return NIL

#endif


function fn_DvolName( cDrive )
// Get the volume name for the drive.
local cDvolname := ""
local nDrive,nHandle,cPath,nI

nDrive  := Drivenum(cDrive)
nHandle := fn_getdh(nDrive)
if nHandle > 0
   cPath := fn_getpath(nHandle)   // Full path name (including volume)
   if (nI := at(":",cPath)) > 0
      cDvolname := substr(cPath,1,nI-1)
   endif
endif

return cDVolname

STATIC Function drivenum(cDirectory)
// Return the drive number (A = 0, B = 1) for a directory (Novell style)
LOCAL nDrive,cDrive
cDrive := substr(cDirectory,1,1)
nDrive := asc(upper(cDrive))-asc("A")
Return nDrive
