//  Program Ŀ
//        Author: Kelly M. Stanonik                                          
//  Date created: 06-17-93      @ 09:44:57am                                 
//     Copyright: 1993 by Kelly M. Stanonik  All Rights Reserved             
// 

// FORMS
//
// Data Driven printed form generation in clipper.  Use these forms sourced
// in a database file to make changes to customer forms easier and more
// trouble free.  See FORMS.DOC for information on usage, etc.
//
// These functions are provided without Warranty of any kind.  Please use
// at your own risk.  I would appreciate being informed of enhancements to
// this concept and would gladly consolate enhancements into this small
// package.
//
// This software is SMOKEWARE.  Due to the fact that I've recently picked up
// the nasty cigarette habit I would appreciate a donation if you can afford
// it in an increment of $2.50 (1 increment of $2.50 recommended).  In any
// event feel free to use and incorporate these functions into your software
// free of charge.
//
// Kelly M. Stanonik
// 1415 West North #317
// Anaheim, CA 92801
// (714) 758-2904
//
// CIS: 70672,610
//
// 93.06.17 KMS     Original Release Version

static cPrOnEmphasized      := "(s3B"
static cPrOnExpanded        := ""
static cPrOffEmphasized     := "(s0B"
static cPrOffExpanded       := ""

//  Function Ŀ
//   Description:                                                            
//        Author: Kelly M. Stanonik                                          
//  Date created: 06-17-93      @ 09:41:26am                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
function PrintForm(aForm)
    local i, nInfoLen := len(aForm)

    for i := 1 to nInfoLen
        PrintFmtOn(aForm[i, 4])
        @ aForm[i, 1], aForm[i, 2] say eval(aForm[i, 3])
        PrintFmtOff(aForm[i, 4])
    next i
    return(.t.)

//  Procedure Ŀ
//   Description: Build eval-able Info array for a particular page-report    
//        Author: Kelly M. Stanonik                                          
//  Date created: 05-03-93      @ 06:17:34pm                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
procedure GetRptDef(cRptID, aInfo)
    local lRptDefOpen, nWorkArea := select(), bOutput

    if OpenDBF("rptdef", "rptdef", "rd_id", @lRptDefOpen)
        if dbseek(cRptID, .f.)
            aInfo := {}
            do while cRptID == trim(rptdef->rpt_id)
                if substr(rptdef->rpt_info, 1, 1) == "{"
                    //
                    // Codeblock Passed.  Compile it
                    //

                    bOutput := &(trim(rptdef->rpt_info))
                else
                    //
                    // String Passed. Convert to Codeblock and Compile
                    //

                    bOutput := &('{|| "' + trim(rptdef->rpt_info) + '"}')
                endif
                aadd(aInfo, { rptdef->row, rptdef->col, bOutput, rptdef->rpt_fmt })
                skip
            enddo
        endif
    endif
    CloseDBF("rptdef", ! lRptDefOpen)
    select(nWorkArea)
    return

//  Procedure Ŀ
//   Description: Open a single database file, return it's opened status     
//        Author: Kelly M. Stanonik                                          
//  Date created: 05-04-93      @ 09:53:04am                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
static function OpenDBF(cDBF, cAlias, cIndex, lIsOpen)
    if is_open(cDBF)
        lIsOpen     := .t.
    else
        lIsOpen     := .f.
        dbusearea(.t., ,cDBF, cAlias, .t.)
        set index to (cIndex)
    endif
    return(.t.)

//  Procedure Ŀ
//   Description: Close a single database file                               
//        Author: Kelly M. Stanonik                                          
//  Date created: 05-04-93      @ 09:53:29am                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
static procedure CloseDBF(cDBF, lClose)
    local nWorkArea := select()
    if lClose
        select (cDBF)
        use
        select(nWorkArea)
    endif
    return

//  Function Ŀ
//   Description: Return .t. if the current alias is already open.           
//        Author: Kelly M. Stanonik                                          
//  Date created: 06-17-93      @ 10:27:28am                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
function is_open(cAlias)
    local i, lRet

    i := 1
    do while ! (trim(upper(cAlias)) == trim(alias(i))) .and. (i < 200)
        i++
    enddo
    if trim(upper(cAlias)) == trim(alias(i))
        lRet := .t.
    else
        lRet := .f.
    endif
    return(lRet)

//  Procedure Ŀ
//   Description: Enable Formatting Codes for this field                     
//        Author: Kelly M. Stanonik                                          
//  Date created: 05-04-93      @ 11:22:33am                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
static procedure PrintFmtOn(cFormat)
    local nOldRow := prow(), nOldCol := pcol()

    //
    // Bold
    //

    if "B" $ cFormat
        ?? cPrOnEmphasized
    endif

    //
    // Expanded
    //

    if "X" $ cFormat
        ?? cPrOnExpanded
    endif
    setprc(nOldRow, nOldCol)
    return

//  Procedure Ŀ
//   Description: Disable Formatting Codes for this field                    
//        Author: Kelly M. Stanonik                                          
//  Date created: 05-04-93      @ 11:22:49am                                 
//     Copyright: Profit Concepts, Inc.                                      
// 
static procedure PrintFmtOff(cFormat)
    local nOldRow := prow(), nOldCol := pcol()

    if "B" $ cFormat
        ?? cPrOffEmphasized
    endif

    if "X" $ cFormat
        ?? cPrOffExpanded
    endif
    setprc(nOldRow, nOldCol)
    return
