#include "stdafx.h"
#include "star.h"

#define RANDOM( min, max ) ((rand() % (int)(((max)+1) - (min))) + (min))

CStarField::CStarField()
{
	for (int i = 0; i < g_nMaxStars; i++)
		m_cStar[i] = NULL;
}  // Constructor, gets called on creation of class

CStarField::~CStarField()
{
	for (int i = 0; i < g_nMaxStars; i++)
		if (m_cStar[i])
			delete m_cStar[i];
}  // Deconstructor, gets called on destruction of class

BOOL CStarField::SetUpStars(int nNumStars)
{
	if (nNumStars > g_nMaxStars)
	{
		MessageBox (NULL, "Too many stars! Aborting!", "Error", 0);
		return FALSE;
	}

	for (int i = 0; i < g_nMaxStars; i++)
		if (m_cStar[i])
			delete m_cStar[i];

	m_nTotStars = nNumStars;
	for (i = 0; i < nNumStars; i++)
	{
		m_cStar[i] = new CStar;
		if (!m_cStar[i])
		{
			MessageBox (NULL, "Unable to allocate memory! Aborting!", "Error", 0);
			return FALSE;
		}
		
		do
		{
			m_cStar[i]->m_nXPos = RANDOM (-320, 320);
			m_cStar[i]->m_nYPos = RANDOM (-200, 200);
			m_cStar[i]->m_nZPos = i+1;
			m_cStar[i]->m_nOldX = -1;
			m_cStar[i]->m_nOldY = -1;
		} while ((m_cStar[i]->m_nXPos == 0) || (m_cStar[i]->m_nYPos == 0));
	}
	
	return TRUE;
}

void CStarField::DrawStarField (HDC pDC)
{
	int nX, nY;
	for (int i = 0; i < m_nTotStars; i++)
	{
		SetPixel (pDC, m_cStar[i]->m_nOldX, m_cStar[i]->m_nOldY, RGB (0, 0, 0));
			//	Clear last position of this star

		nX = (int)((((long)m_cStar[i]->m_nXPos << 7) / (long)m_cStar[i]->m_nZPos) + m_nCenterX);
		nY = (int)((((long)m_cStar[i]->m_nYPos << 7) / (long)m_cStar[i]->m_nZPos) + m_nCenterY);
		SetPixel (pDC, nX, nY, RGB (0, 0, 255));
			// Draw star

		m_cStar[i]->m_nOldX = nX;
		m_cStar[i]->m_nOldY = nY;
			// Remember current position for clearing later
	}
}

void CStarField::MoveStarField (int nXofs, int nYofs, int nZofs)
{
	for (int i = 0; i < m_nTotStars; i++)
	{
		m_cStar[i]->m_nXPos += nXofs;
		m_cStar[i]->m_nYPos += nYofs;
		m_cStar[i]->m_nZPos += nZofs;
		if (m_cStar[i]->m_nZPos > m_nTotStars)
			m_cStar[i]->m_nZPos -= m_nTotStars;
		if (m_cStar[i]->m_nZPos < 1)
			m_cStar[i]->m_nZPos += m_nTotStars;
	}
}

void CStarField::SetDimensions (int nWidth, int nHeight)
{
	m_nCenterX = nWidth / 2;
	m_nCenterY = nHeight / 2;
}
