#include "stdafx.h"	// Okay, so it doesn't include MFC stuff... sue me. It has all the common
					//	.h files I use.
#include "demo.h"

BOOL	g_bUserTimer = FALSE;
			// Set to use either WM_TIMER or PeekMessage method of animation
			
long FAR PASCAL WndProc (HWND hWnd, WORD iMessage, WORD wParam, LONG lParam);
			// Forward declaration


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	MSG Message;
	WNDCLASS WndClass;

	if (!hPrevInstance)
	{
		WndClass.cbClsExtra = 0;
		WndClass.cbWndExtra = 0;
		WndClass.hbrBackground = GetStockObject (BLACK_BRUSH);
		WndClass.hCursor = LoadCursor (NULL, IDC_ARROW);
		WndClass.hIcon = LoadIcon (NULL, IDI_APPLICATION);
		WndClass.hInstance = hInstance;
		WndClass.lpfnWndProc = (WNDPROC) WndProc;
		WndClass.lpszClassName = "STAR_WINDOW";
		WndClass.lpszMenuName = NULL;
		WndClass.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;

		RegisterClass (&WndClass);
	}
	HWND hWnd = CreateWindow ("STAR_WINDOW", "Asphyxia Stars", WS_OVERLAPPEDWINDOW|WS_MAXIMIZE,
					50, 100, 320, 200, NULL, NULL, hInstance, NULL);
	

    if (!g_csStars.SetUpStars(500))
    	return 0;
    	
	ShowWindow (hWnd, SW_SHOWMAXIMIZED);
	UpdateWindow (hWnd);
	

	if (g_bUserTimer)
	{
		while (GetMessage (&Message, 0, 0, 0))
		{
			TranslateMessage (&Message);
			DispatchMessage (&Message);
		}
	}
	else
	{
		while (TRUE)
		{
			g_csStars.MoveStarField (0, 0, -3);
			HDC pDC = GetDC(hWnd);
			g_csStars.DrawStarField (pDC);
			ReleaseDC(hWnd, pDC);
			
			if (PeekMessage (&Message, NULL, 0, 0, PM_REMOVE))
			{
				if (Message.message == WM_QUIT)
					return Message.wParam;
				
				TranslateMessage (&Message);
				DispatchMessage (&Message);
			}
		}
	}
	
	return Message.wParam;
}

long FAR PASCAL WndProc (HWND hWnd, WORD iMessage, WORD wParam, LONG lParam)
{
	switch (iMessage)
	{
		case WM_CREATE :
		{
			if (g_bUserTimer)
				SetTimer (hWnd, 1, 10, NULL);
		}
		break;
		case WM_PAINT :
		{
			PAINTSTRUCT	PtStr;
			HDC pDC = BeginPaint (hWnd, &PtStr);
			g_csStars.DrawStarField (pDC);
			EndPaint (hWnd, &PtStr);
			return (0);
		}
		break;
		case WM_TIMER :
		{
			if ((wParam == 1) && g_bUserTimer)
			{
				g_csStars.MoveStarField (0, 0, -3);
				HDC pDC = GetDC(hWnd);
				g_csStars.DrawStarField (pDC);
				ReleaseDC(hWnd, pDC);
			}
		}
		break;
		case WM_SIZE :
		{
			g_csStars.SetDimensions (LOWORD(lParam), HIWORD(lParam));
				//	Change the center point of the starfield
		}
		break;
		case WM_DESTROY :
		{
			if (g_bUserTimer)
				KillTimer (hWnd, 1);
			PostQuitMessage (0);
			return 0;
		}
		break;
	}
	return (DefWindowProc (hWnd, iMessage, wParam, lParam) );
}

