#include <asm/io.h>

#include "vga.h"

int vga_mode_get(struct vgamode_t *themode)
{
	int i;

	themode->MiscOutReg = inb(0x3CC);

	inb(0x3DA);
	outb(0x00, 0x3C0);

	for (i=0; i<25; i++) {
		outb(i, 0x3D4); 
		themode->CRTC[i] = inb(0x3D5);
	}

	for (i=0; i<21; i++) {
		inb(0x3DA);
		outb(i, 0x3C0);
		themode->Attribute[i] = inb(0x3C1);
	}

	for (i=0; i<9; i++) {
		outb(i, 0x3CE);
		themode->Graphics[i] = inb(0x3CF);
	}

	for (i=0; i<5; i++) {
		outb(i, 0x3C4);
		themode->Sequencer[i] = inb(0x3C5);
	}

	inb(0x3DA);
	outb(0x20, 0x3C0);

	return VGA_OK;
}

int vga_mode_set(struct vgamode_t *themode)
{
	int i;

	inb(0x3DA);
	outb(0x00, 0x3C0);

	outb((themode->MiscOutReg | 1), 0x3C2);

	for (i=0; i<5; i++)
		outw(((themode->Sequencer[i] << 8) | i), 0x3C4);

	outw((((themode->CRTC[17] & 0x7F) << 8) | 17), 0x3D4);

	for (i=0; i<25; i++)
		outw(((themode->CRTC[i] << 8) | i), 0x3D4);

	for (i=0; i<9; i++)
		outw(((themode->Graphics[i] << 8) | i), 0x3CE);

	for (i=0; i<21; i++) {
		inb(0x3DA);
		outb(i, 0x3C0);
		outb(themode->Attribute[i], 0x3C0);
	}

	inb(0x3DA);
	outb(0x20, 0x3C0);

	return VGA_OK;
}
