#ifndef __VGA_H__
#define __VGA_H__

#define VGA_MAJOR 48
#define VGA_MINOR_CHAINED 0
#define VGA_MINOR_UNCHAINED 1

#define VGA_OK 0

/* ioctl() numbers... */
#define VGA_BANK_GET 0
#define VGA_BANK_SET 1
#define VGA_MODE_SET 2
#define VGA_MODE_GET 3
#define VGA_PAL_GET 4
#define VGA_PAL_SET 5
#define VGA_TEXT_GET 6
#define VGA_TEXT_SET 7

#define VGA_PAGE_OFFSET 0x0A0000
#define VGA_PAGE_SIZE 0xFFFF

struct vgamode_t {
	char name[64];
	unsigned char Attribute[21];
	unsigned char CRTC[24];
	unsigned char Graphics[9];
	unsigned char MiscOutReg;
	unsigned char Sequencer[5];
} ;

struct vgapal_t {
	char name[64];
	unsigned char DAC[768];
} ;

struct vgatext_t {
	char name[64];
	unsigned char text0[16384];
	unsigned char text1[16384];
	unsigned char font0[16384];
	unsigned char font1[16384];
} ;

extern int vga_bank_get(unsigned short *bank);
extern int vga_bank_set(unsigned short *bank);
extern int vga_mode_get(struct vgamode_t *themode);
extern int vga_mode_set(struct vgamode_t *themode);
extern int vga_pallete_get(struct vgapal_t *thepallete);
extern int vga_pallete_set(struct vgapal_t *thepallete);
extern int vga_text_get(struct vgatext_t *thetext);
extern int vga_text_set(struct vgatext_t *thetext);
#endif
