
/***************
**
**  userlist.c
**  last revised: april 10, 1992
**
**  Userlist version 1.00 alpha, Copyright (C)1992 Zabkar
**  DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.
**
**  Userlist creates a dictionary from all usernames from the passwordlist
**  on stdin or the file, specified with the -f switch. Output is written on
**  stdout or the file defined with the -o switch.
**
**  Usage: userlist [-c] [-l] [-1] [-r] [-n] [-f passwordfile] [-o outfile]
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>
#include "dictword.h"
#include "pwd.h"


FILE *outfile;
FILE *infile;

extern FILE *_pw_file;     /* So sneaky it could have been from CC! */


/***************
 haltusage()
 prints correct usage and exits
****************/

void haltusage()
{
  fprintf(stderr,
  "Userlist version 1.00 alpha, Copyright (C)1992 Zabkar\n"\
  "DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.\n\n"\
  "Usage: userlist [-c] [-l] [-1] [-r] [-n] [-f passwordfile] "\
  "[-o outfile]\n\n"\
  "\t-c: capitalize whole word\n"\
  "\t-l: lowercase whole word\n"\
  "\t-1: all lowercase, first uppercase\n"\
  "\t-r: all selected options reversed, too\n"\
  "\t-f: read from 'passwordfile' instead of stdin\n"\
  "\t-o: write to 'outfile' instead of stdout\n\n"\
  "Use of one of the options c, l or 1 causes the normal word to disapear,\n"\
  "to have the normal form back again, add the -n switch.\n\n"\
  "no -f specified: passwordfile read from stdin\n"\
  "no -o specified: output written to stdout\n");
  exit(0);
}



/***************
 createuserlist()
 creates a userlist from input given on file inf and writes output to
 file of. All conversions of mode are taken care of.
****************/

void createuserlist(FILE *inf, FILE *of, int mode)
{
    struct passwd *buf;
    char buffer[256];
    char dest[256];

    _pw_file = inf;

    while ((buf=getpwent()) != NULL)
    {
       strcpy(buffer, "");
       if (mode & NORMAL || mode & EXTNORMAL)
       {
          strcat(buffer, buf->pw_name);
          strcat(buffer, "\n");
       }

       if (mode & LOWER)
       {
          strcat(buffer, all_lower(dest, buf->pw_name));
          strcat(buffer, "\n");
       }

       if (mode & UPPER)
       {
          strcat(buffer, all_upper(dest, buf->pw_name));
          strcat(buffer, "\n");
       }

       if (mode & FIRSTUP)
       {
          strcat(buffer, first_upper(dest, buf->pw_name));
          strcat(buffer, "\n");
       }

       if (mode & REVERSE)
       {
          reverse(dest, buffer);    /* reverse of all the above */
          strcat(buffer, &dest[1]); /* strip leading newline */
          strcat(buffer, "\n");     /* add line-feed to end */
       }

       fprintf(of, "%s", buffer);   /* Print all words on of */
    }
}



/***************
 main()
 main function of program mailist
****************/

main(char argc, char **argv)
{
  char fname[80], oname[80];
  int i;
  int convmode = NORMAL;

  strcpy(fname, "");
  strcpy(oname, "");

  if (argc > 1)
  {
    for (i=1; i<argc; i++)
    {
      switch(argv[i][0])
      {
      case '-': switch(toupper(argv[i][1]))
		  {
            case 'F' : if (strlen(argv[i]) > 2)
                 strcpy(fname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(fname, argv[++i]);
			       break;
            case 'O' : if (strlen(argv[i]) > 2)
                 strcpy(oname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(oname, argv[++i]);
			       break;
            case 'C': convmode |= UPPER; convmode &= ~NORMAL; break;
            case 'L': convmode |= LOWER; convmode &= ~NORMAL; break;
            case '1': convmode |= FIRSTUP; convmode &= ~NORMAL; break;
            case 'R': convmode |= REVERSE; break;
            case 'N': convmode |= EXTNORMAL; break;
            default  : haltusage();
		  }
          break;
      default : haltusage();
      }
    }
  }

  if (strcmp(fname,""))
    infile = fopen(fname, "rt");
  else
    infile = stdin;

  if (!infile)
    {
    fprintf(stderr, "%s: couldn't open file\n", fname);
    exit(0);
    }

  if (strcmp(oname, ""))
    outfile = fopen(oname, "wt");
  else
    outfile = stdout;

  if (!outfile)
    {
    fprintf(stderr, "%s: could't create file\n", oname);
    exit(0);
    }

  createuserlist(infile, outfile, convmode);

  fclose(infile);
  fclose(outfile);

  }

/* EOF USERLIST.C */
