	page 60,132
	title	STDERRF - Main Procedure for the STDERRF Application
	name	STDERRF
	
comment 
	STDERRF 						V1.00
----------------------------------------------------------------------------
NAME
	STDERRF 		Main Procedure for the STDERRF Application

SYNOPSIS
	STDERRF Filename Exename ["Command Line"]

	where
		Filename is the file that the STDERR from Exename program
			is to be redirected.
		Exename is the full drive:path/filename.ext of the program
			that STDERRF is to execute and redirect the the
			STDERR.
		Command Line is an option arguement that is the command line
			for the Exename application.  If there are any embedded
			blanks, the entire string must be delimited by double
			quotes.

DESCRIPTION
	The basic outline of STDERRF is:
	1.  Accepts three command line arguments:
	    a.	The full path and filename of the file into which STDERR is
		to be written.
	    b.	The full path and filename of the program to be executed.
	    c.	The command line for the program to be executed (should be
		delimited by double quotes to allow multiple arguments).
		This  argument is optional.
	2.  Releases all memory above the program using Int 21 function 4ah
	    so that there will be room enough to load and execute the
	    designated program.
	3.  Opens the file from step #1.a above into which STDERR is to be
	    written.  If file exists, ask user to continue.  If to continue,
	    ask user if the file is to be truncated or output appended.
	    Perform the requested actions.
	4.  Duplicates STDERR filehandle using Int 21h function 45h.
	5.  Uses Int 21h function 46h, force STDERR filehandle to have the
	    filehandle of the opened file from step #2.
	6.  Uses Int 21h function 4b00h to load and execute the program from
	    step #1.a.	Use the default environment and the command line from
	    step #1.c above.
	7.  Upon return from the function 4b00h, closes the file opened in
	    step #2.
	8.  Restores STDERR using Int 21h function 46h to force STDERR to
	    point to the filehandle saved from step #3 above.

PROGRAMMING NOTES
	STDERRF was assembled using MASM 6.11A with the following settings:
		Preserve Case of Naes in Object File
		Warning Level 3
		Defines: SIMPLE - See STARTUP1.ASM for explanation

	Procedures called:
		Exit			EXIT.ASM
		GetValidChoice		GETVLDC.ASM
	DOS Interrupts:
		Int 21h 3dh - Open File with Handle
		Int 21h 3eh - Close File with Handle
		Int 21h 40h - Write to file or device
		Int 21h 42h - Move File Pointer
		Int 21h 45h - Duplicate File Handle
		Int 21h 46h - Force duplication of filehandle
		Int 21h 4bh - Load and Execute Program
		Int 21h 5bh - Create New File

MEMORY REQUIREMENTS
	STDERRF.ASM
		Stack:	  4 bytes
		Data:	 32 bytes
		_BSS:	128 bytes
		Const:	187 bytes
		Code:	314 bytes

	STDERRF Appliation
		Stack:	512 bytes
		Data:	 83 bytes
		_BSS:	128 bytes
		Common:  12 bytes
		Const:	760 bytes
		Code:	699 bytes

	STDERRF requires 3,184 bytes of memory to exectute plus the size of
	the passed environment and environment's Memory Control Block which
	is 16 bytes.

RETURNS
	If no errors, returns the return code of the executed program to
	the Start_Up1S to be STDERRF's return code.

CAUTIONS

AUTHOR
	Raymond Moon - 5 Mar 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  5 Mar 95	- Orginal
	
	 End of Comment
	
	include procesor.inc
%	.MODEL	small,FORTRAN
	assume	es:DGROUP

;-----------------------------
;	Include files

	include stderrf.inc

;=========================================================================
;	Equates
;=========================================================================

;----------------------------
;	ARGV equates. Using the SIMPLE option, ARGV is argv[0] vice a pointer
;	to them.

argvStdErrFile	equ	ARGV
argvExeFilename	equ	ARGV + 2
argvCommandTail equ	ARGV + 4

;=========================================================================
;	Structures
;=========================================================================

LPtr	struc				; Long Pointer structure
lpOffset	dw	?		; Offset
lpSeg		dw	?		; Segment
LPtr	ends

LoadExec_S	struc
leEnvironment	dw	?		; Environmental block segment address
leCommandTail	LPtr	<>		; Address of Command Tail
leFCB_1 	LPtr	<>		; address of default FCB, #1
leFCB_2 	LPtr	<>		; address of second FCB, #2
LoadExec_S	ends

CommandTail_S	struc
ctLength	db	?		; Length of command tail minus end CR
ctLeadingSpace	db	?		; Initial space to start command tail
ctText		db	126 dup (?)	; Command Tail
CommandTail_S	ends

;=========================================================================
;	DATA
;=========================================================================
	.DATA

EmptyFCB	db		11 dup (20h), 5 dup (00h)
ParamBlk	LoadExec_S	{\
				0,			; Use STDERRF's environ
				{CommandTail, DGROUP},	; LPTR to CommandTail
				{EmptyFCB, DGROUP},	; LPTR to 1st FCB
				{EmptyFCB, DGROUP}}	; LPTR to 2nd FCB
DupStdErr	word		0

	.CONST

LOGO	db	"STDERRF - Redirect STDERR Output To A File Utility", CR, LF,
		"Copyright (c) MoonWare, 1995", CR, LF,
		"ALL RIGHTS RESERVED", CR, LF

REDIR	db	LF, "WARNING:  Redirection File Exists. Continue? (y/n): ",
		BELL
TRUN	db	CR, LF, "Overwrite or Append? (o/a): "

	.DATA?

CommandTail	CommandTail_S	<>

;=========================================================================
;	CODE
;=========================================================================
;	Start CODE segment with the proper relationship with external
;	procedures

	.CODE
extrn	Start_Up1s:near
extrn	Exit:near
extrn	GetValidChoice:near

Main	proc	ARGV:ptr, ARGC:word
local	FileHandle:word

;----------------------------
;	Display LOGO

	@WRITE	LOGO, STDERR

;----------------------------
;	See if there is anything to do.  Must have 2 args min.	If not,
;	display usage

	cmp	ARGC, 2 		; Is ARGC == 2?
	jae	MN1			; It's equal or larger, continue
	mov	ax, eqUSAGE		; Indicate USAGE error
	call	Exit			; Call Exit

;----------------------------
;	See if DOS version is 3.0 or later

MN1:	cmp	OSMAJOR, 3		; Is DOS version 3.0 or better?
	jae	MN2			; Yes, continue
	mov	ax, eqBADDOSVER		; Indicate error type
	call	Exit			; Call Exit

;----------------------------
;	Duplicate STDERR Filehandle

MN2:	mov	bx, STDERR		; BX = handle to duplicate
	mov	ah, 45h 		; Request Duplicate
	int	21h			; Call DOS
	jnc	MN3			; Successful
	mov	bx, ax			; Move DOS Error into BX
	mov	ax, eqDUPERR		; Error, tell user which error
	call	Exit			; Call Exit Routine
MN3:	mov	DupStdErr, ax		; Save Duplicated STDERR Handle

;----------------------------
;	Initialize the Command Tail, if present.  ARGC = 3, if present.

	cmp	ARGC, 2 		; See if equal to 2 and skip
	jbe	MN6			; Yes, skip

	mov	CommandTail.ctLeadingSpace, ' '
					; Initialize the blank

	lea	di, CommandTail.ctText	; DI => Command Tail Text
	mov	si, argvCommandTail	; SI => Passed Command Line
	mov	cx, 1			; CX = counter, starts 1 for space

MN4:	lodsb				; Get the next char
	or	al, al			; Is it a null?
	jz	MN5			; Yes, we are finished
	stosb				; No, store it
	inc	cx			; Account for char
	jmp	MN4			; Go start the process again
MN5:	mov	byte ptr [di], CR	; Terminate with CR
	mov	CommandTail.ctLength, cl; Save length

;----------------------------
;	Open the file into which the stderr will be directed.
;	Open first to see if it already exists.

MN6:	mov	dx, argvStdErrFile	; DS:DX => Filename
	mov	ax, 3d01h		; Open for write only
	int	21h			; Call DOS
	jnc	MN8			; File exists, see what to do

;----------------------------
;	The file could not be opened so it does not exist.  Create the
;	file.

	mov	dx, argvStdErrFile	; DS:DX => filename
	xor	cx, cx			; CX =	Normal Attributes
	mov	ah, 5bh 		; Request Create New File
	int	21h			; Call DOS
	jnc	MN7			; Successful, skip error
	mov	bx, ax			; Move error into BX
	mov	ax, eqCREATEERR 	; Identify type of error
	call	Exit			; Call Exit Routine

MN7:	mov	FileHandle, ax		; No Error, save filehandle
	jmp	MN12			; Skip the open handling code

;----------------------------
;	Save the Filehandle.

MN8:	mov	FileHandle, ax

;----------------------------
;	File exists, see if the user wants to continue.

	@WRITE	REDIR,STDERR		; Display question

	mov	ax, "ny"		; Pass valid choices
	call	GetValidChoice		; Get response
	jnc	MN9			; Yes, user wants to continue
	mov	ax, eqUSERTERM		; Indicate user terminate
	call	EXIT			; Call Exit

;----------------------------
;	The user wants to continue, see if the file is to be appended or
;	truncated.

MN9:	@WRITE	TRUN, STDERR		; Display question

	mov	ax, "ao"		; Pass valid choices
	call	GetValidChoice		; Get user response
	jnc	MN10			; User wants to truncate

;----------------------------
;	User wants to append, set up for a move file pointer to end of file.

	mov	ax, 4202h		; Request move filepointer to end
	jmp	MN11			; Go to the rest of int code

;----------------------------
;	User wants to truncate, set up for a move file pointer to start

MN10:	mov	ax, 4200h		; Request move filepointer to start

;----------------------------
;	Move file pointer to desired starting position

MN11:	mov	bx, FileHandle		; BX = filehandle
	xor	cx, cx			; DX:CX = Offset
	mov	dx, cx			;   Offset = 0000:0000
	int	21h			; Call DOS

;---------------------------
;	Write zero bytes to confirm position

	mov	dx, offset TRUN 	; DS:DX => buffer to print
	xor	cx, cx			; CX = zero length to write
	mov	bx, FileHandle		; BX = Filehandle
	mov	ah, 40h 		; Request write file or device
	int	21h			; Call DOS

;----------------------------
;	Force duplication of STDERR filehandle to FileHandle

MN12:	mov	bx, FileHandle		; BX = new filehandle for STDERR
	mov	cx, STDERR		; CX = filehandle to change
	mov	ah, 46h 		; Request force dup filehandle
	int	21h			; Call DOS
	jnc	MN13			; Error, go tell user
	mov	bx, ax			; Move error into BX
	mov	ax, eqFORCEDUPERR	; Indicate type of error
	call	Exit			; Call Exit

;----------------------------
;	Load and execute program.

MN13:	mov	dx, argvExeFilename	; DS:DX => Filename to execute
	mov	bx, offset ParamBlk	; ES:BX => Parameter block
	mov	ax, 4b00h		; Request load and execute
	int	21h			; Call DOS
	jnc	MN14			; No error, continue

	mov	bx, ax			; Error, move error code into BX
	mov	ax, eqEXECERR		; Indicate the type of error
	call	Exit			; Call Exit

;----------------------------
;	Restore STDERR by force duplicating STDERR handle back to saved
;	filehandle for STDERR

MN14:	mov	cx, DupStdErr		; CX = new handle for STDERR
	mov	bx, STDERR		; BX = handle to change
	mov	ah, 46h 		; Request force dup filehandle
	int	21h			; Call DOS
	jnc	MN15			; No error, continue

	mov	DupStdErr, 0		; Indicate not to redirect STDERR
					;   again
	mov	bx, ax			; Error, move error code into BX
	mov	ax, eqRESTOREERR	; Indicate the type of error
	call	Exit			; Call Exit

;----------------------------
;	Zero DupStdErr so that after any future errors the Exit procedure
;	will not attempt to restore STDERR.

MN15:	mov	DupStdErr, 0		; Indicate not to redirect STDERR
					;   again

;----------------------------
;	Close redirected file.

	mov	bx, FileHandle		; BX = Filehande to close
	mov	ah, 3eh 		; Request close filehandle
	int	21h			; Call DOS
	jnc	MN16			; No error, continue

	mov	bx, ax			; Error, move error code into BX
	mov	ax, eqCLOSEERR		; Indicate the type of error
	call	Exit			; Call Exit

;----------------------------
;	Return to startup code with the return code of the child program.

MN16:	mov	ah, 4dh 		; Request get child return code
	int	21h			; Call DOS
	ret				; Return to startup code to exit

Main	endp
	end
