@ECHO OFF

REM Tidy up and then do the conversion using Doormaster 5.3.2
REM DM is using a locked baud rate of 38400 here.

   del caller.

REM use the below line if a full pcboard.dat resides in the node dir
REM (locked baud rate ony!!!).
  dm /f=RA /t=PCB14C /N%1 /LB=38400

REM use the below line if you are using pad.* to make a pcboard.dat

REM   dm /f=RA /t=PCB14 /N=%1 /LB=38400

REM pad out pcboard.dat to correct length using correct pad.* file
REM then tidy up afterwards. REM these lines out if you are using
REM the PCB14C option above.

REM   ren pcboard.dat pcb.dat
REM   copy pcb.dat+d:\zlab\pad.%3 pcboard.dat
REM   del pcb.dat

REM zlab expects a file called caller, so we give it one.

   rem>caller

REM test file using ZipLab 1.9c

   d:\zlab\zlab.exe %2 d:\ra\node%1 d:\zlab


REM Check to see if the file passed or failed then deal with it.

   if exist d:\ra\node%1\pcbfail.txt goto FAIL

goto OKAY

REM Here we deal with the file if it failed.

:FAIL

REM log the reason for failure.

   copy d:\zlab\zlab.log+caller d:\zlab\zlab.log

REM inform the user why it failed by copying reason for failure to a
REM textfile displayed by RA at the prompt (requies you to edit the
REM language file line 637).

   copy caller d:\ra\txtfiles\fail.asc

REM delete the flagfile created by ziplab.

   del pcbfail.txt

REM ZipLab will have moved the file so we have to move the file back
REM to ra's upload area so ra can deal with it.

   c:\utils\move.exe d:\upload\temp\*.* d:\upload

REM tell ra the filescan has failed by setting the errorlevel to 1.
REM Then exiting.

   c:\utils\errlvl.exe 1
   exit

REM If the file passed  we just exit cleanly.

:OKAY

  exit
