;
; FNOBREAK.ASM
; suggested assembler : TASM >= 1.0
;
; Assembler module for FNOBREAK.PAS,
; { FIDO unit to avoid <Pause>, <ctrl-Break> and <ctrl-alt-Del> }
;
;****************************************************************************
;
;        RELEASE 1.02 - as first contained in the file PRUS101.LZH
;                 by Paul Schubert, 2:244/1181.18, GERMANY
;
;               --------------------------------------------
;                organized for Fido's PASCAL related echoes
;               --------------------------------------------
;
;     06/21/1994 to --/--/---- by Paul Schubert, 2:244/1181.18, GERMANY
;
;
;           Those who contributed to the following piece of source,
;           listed in alphabethical order:
;        ================================================================
;           Paul Schubert
;        ================================================================
;
;****************************************************************************
;
; This routine will be hooked in keyboard interrupt 9h
; in order to catch certain keystrokes as PAUSE, CTRLALTDEL,
; BREAK and PRTSCR.
;
; the keystrokes will be reported to the main programme by the
; following variables:
;
; PAUSEK : BOOLEAN; Pause pressed
; BREAKK : BOOLEAN; ctrl-alt-Del pressed
; CTRBRK : BOOLEAN; ctrl-Break pressed
; PRTSCK : BOOLEAN; shift-PrtScr pressed
;
;******************************************************

DATA    SEGMENT BYTE PUBLIC

        EXTRN   PAUSEK : BYTE
        EXTRN   BREAKK : BYTE
        EXTRN   CTRBRK : BYTE
        EXTRN   PRTSCK : BYTE

DATA    ENDS

;****************************************************** Code

CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE, DS:DATA

        PUBLIC  InitKbdVectors, RestoreKbdVectors;
        PUBLIC  NewInt09,NewInt05,PrintScreen

;CS-relative variables, easily accessible to interrupt handlers
PrevInt09       LABEL DWORD
PrevInt09Ofs    DW ?
PrevInt09Seg    DW ?
PrevInt05       LABEL DWORD
PrevInt05Ofs    DW ?
PrevInt05Seg    DW ?

;*********************************************************** NewInt05
;Handle PRTSCR interrupt

NewInt05        PROC FAR

        PUSH    AX
        PUSH    DS
        MOV     AX,SEG DATA
        MOV     DS,AX                   ;Point to Turbo data area
        MOV     PRTSCK,0FFH             ; PRINT SCREEN MARKIEREN
        POP     DS
        POP     AX
        IRET                            ;Return to caller

NewInt05        ENDP

;*********************************************************** NewInt05
; CALL old PRINTSCREEN handler

PrintScreen     PROC FAR

        PUSHF
;       JMP     PrevInt05               ;Transfer to previous interrupt 05
        CALL    CS:PrevInt05            ;Transfer to previous interrupt 05
        RET

PrintScreen     ENDP

;*********************************************************** NewInt09
;Handle hardware keyboard interrupts

        BiosShiftFlags  EQU BYTE PTR 17h  ;Addresses in BIOS data area
        E0FLAG          EQU BYTE PTR 96H

NewInt09        PROC FAR

        STI                             ;Interrupts on
        PUSH    AX                      ;Save registers we use
        PUSH    BX
        PUSH    CX
        PUSH    DS

        MOV     AX,0040h
        MOV     DS,AX                   ;Point to BIOS data area
        IN      AL,60h                  ;Read scan code

        CMP     AL,45H                  ; PAUSE ?
        JE      PAUSE                   ; JA - ABFANGEN

        TEST    DS:BIOSSHIFTFLAGS,00000100B
        JE      INT09ORIG               ; NUR CTRL TESTEN

        CMP     AL,46H                  ; BEI CTRL-BREAK KOMMT MAKECODE E0 46
        JE      CTRLBR

        TEST    DS:BIOSSHIFTFLAGS,00001000B
        JNE     CTRLALT                 ; Ctrl-Alt : AUF Del TESTEN

Int09Orig:                              ;Let BIOS int 09 handler take care of it
        POP     DS                      ;Restore registers
        POP     CX
        POP     BX
        POP     AX
        JMP     PrevInt09               ;Transfer to previous interrupt 09

PAUSE:
        TEST    DS:BIOSSHIFTFLAGS,00000100B
        JNE     _PAUSE                  ; CTRL IST BEI K3P GESETZT
        TEST    DS:E0FLAG,00000001b     ; E1- FLAG GESETZT ? ( FR KEYB )
        JE      INT09ORIG
_PAUSE: MOV     AX,SEG DATA
        MOV     DS,AX                   ;Point to Turbo data area
        MOV     PAUSEK,0FFH             ; PAUSE MARKIEREN
        JMP     ZURUECK

CTRLBR:
;       TEST    DS:E0FLAG,00000010b     ; E0- FLAG GESETZT ?
;       JE      INT09ORIG

;       AND     DS:E0FLAG,11111101B     ; RESET E0- FLAG
        MOV     AX,SEG DATA
        MOV     DS,AX                   ;Point to Turbo data area
        MOV     CTRBRK,0FFH             ; BREAK MARKIEREN
        JMP     ZURUECK

CTRLALT:
        IN      AL,60h                  ;Read scan code
        CMP     AL,53H                  ;Is it 53h?
        JNE     Int09Orig               ;If not, pass on to BIOS int 09 handler

ISBREAK:
        AND     DS:E0FLAG,11111101B     ; RESET E0- FLAG
        MOV     AX,SEG DATA
        MOV     DS,AX                   ;Point to Turbo data area
        MOV     BREAKK,0FFH             ; CTRL- ALT- DEL MARKIEREN

; TASTATURCODE VERNICHTEN UND ZURCK
ZURUECK:
        IN      AL,61h                  ;Read control port value
        MOV     AH,AL                   ;Save in AH
        OR      AL,80h                  ;Set high bit
        OUT     61h,AL                  ;Reset keyboard
        MOV     AL,AH                   ;Retrieve original value
        OUT     61h,AL                  ;Enable keyboard
        CLI                             ;Stop CPU interrupts
        MOV     AL,20h                  ;End of interrupt
        OUT     20h,AL                  ;To the interrupt controller

        STI                             ;Interrupts on
        POP     DS                      ;Restore registers
        POP     CX
        POP     BX
        POP     AX
        IRET                            ;Return to caller

NewInt09        ENDP

;*********************************************************** InitKbdVectors

;Save and setup interrupt vectors

InitKbdVectors  PROC FAR

        MOV     AX,3509h                ;Get current int 9
        INT     21h
        MOV     PrevInt09Ofs,BX         ;Save it in CS-relative variables
        MOV     PrevInt09Seg,ES
        PUSH    DS
        PUSH    CS
        POP     DS
        MOV     DX,offset NewInt09
        MOV     AX,2509h                ;Install new int 9
        INT     21h
        POP     DS

        MOV     AX,3505h                ;Get current int 5
        INT     21h
        MOV     PrevInt05Ofs,BX         ;Save it in CS-relative variables
        MOV     PrevInt05Seg,ES
        PUSH    DS
        PUSH    CS
        POP     DS
        MOV     DX,offset NewInt05
        MOV     AX,2505h                ;Install new int 5
        INT     21h
        POP     DS

        RET

InitKbdVectors  ENDP

;*********************************************************** RestoreKbdVectors

;Restores original vectors for INT's $09 and $16

RestoreKbdVectors       PROC FAR
        PUSH    DS

        MOV     AX,PREVINT09SEG
        PUSH    AX
        POP     DS
        MOV     DX,PREVINT09OFS
        MOV     AX,2509h                ;Install old int 9
        INT     21h

        MOV     AX,PREVINT05SEG
        PUSH    AX
        POP     DS
        MOV     DX,PREVINT05OFS
        MOV     AX,2505h                ;Install old int 5
        INT     21h

        POP     DS

        RET

RestoreKbdVectors       ENDP

CODE    ENDS
        END

 nderungen
 ----------
 in 1.02
 ------------
29.07.1994  E0FLAG Adresse korrigiert
            PRINTSCREEN Absturz korrigiert
            Abfangen von PAUSE korrigiert
