Unit FKBD; { FIDO Unit for keyboard handling and manipulation }
 (***************************************************************************

            RELEASE 1.03 - as contained in the file PRUS100.LZH
                by Orazio Czerwenka, 2:2450/540.55, GERMANY

               --------------------------------------------
                organized for Fido's PASCAL related echoes    
               --------------------------------------------

     05/22/1994 to --/--/---- by Orazio Czerwenka, 2:2450/540.55, GERMANY


           As far as third party copyrights are not violated this
           source code is hereby placed to the public domain. Use
           it whatever way you want, but use AT YOUR OWN RISK.

           In case you should modify the source rather send your
           modifications to the unit's current organizer (see above for
           NM address) than to spread it on your own. This will help to
           keep the unit updated and grant a certain standard to all
           other users as well.

           The unit is currently still under work. So it might greatly
           benefit of your participation.

           Those who contributed to the following piece of source,
           listed in alphabethical order:
        ================================================================
           Martin Austermeier (Unit ReadKBD), Orazio Czerwenka, German
           Borland HOST Langen (buffstuff.pas,flushkey.pas), Max
           Maischein (Units CRT2.PAS and CHEAPCRT.PAS)...
        ================================================================
           YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

           Special thanx to Max Maischein and Paul Schubert for pointing
           out the advantages of word based keyboard related operations.

           Credits in your own programs are owed to Max Maischein as
           demanded in his Units CRT2 and CHEAPCRT and to Borland in
           general as well as to Martin Austermeier for his PD unit
           ReadKBD.

 ***************************************************************************)

{$I FDEFINE.DEF}

interface

type
  KbdBuff     = array[30..62] of byte;  { doesn't work as [0..32] ! why?  }

CONST
  {        key codes         }
  NUL        = $0000;  BKSPC      = $0E08;   TAB       = $0F09;
  CR         = $1C0D;  ESC        = $011B;   SPC       = $3920;

  {   enhanced key codes   }
  SHIFT_TAB  = $0F00;
  CTRL_TAB = $9400;

  HOME       = $4700;  UP         = $4800;  PGUP       = $4900;
  LEFT       = $4B00;  MIDDLE     = $4C35;  RIGHT      = $4D00;
  ENDE       = $4F00;  DOWN       = $5000;  PGDN       = $5100;
  INS        = $5200;  DEL        = $5300;

  GRAYPLUS   = $4E2B;  GRAYMINUS  = $4A2D;  GRAYDIV    = $E02F;
  GRAYMUL    = $372A;  GRAYCR     = $E00D;

  F1         = $3B00;  F2         = $3C00;  F3         = $3D00;
  F4         = $3E00;  F5         = $3F00;  F6         = $4000;
  F7         = $4100;  F8         = $4200;  F9         = $4300;
  F10        = $4400;  F11        = $8500;  F12        = $8600;

  SHIFT_F1   = $5400;  SHIFT_F2   = $5500;  SHIFT_F3   = $5600;
  SHIFT_F4   = $5700;  SHIFT_F5   = $5800;  SHIFT_F6   = $5900;
  SHIFT_F7   = $5A00;  SHIFT_F8   = $5B00;  SHIFT_F9   = $5C00;
  SHIFT_F10  = $5D00;  SHIFT_F11  = $8700;  SHIFT_F12  = $8800;

  CTRL_F1    = $5E00;  CTRL_F2    = $5F00;  CTRL_F3    = $6000;
  CTRL_F4    = $6100;  CTRL_F5    = $6200;  CTRL_F6    = $6300;
  CTRL_F7    = $6400;  CTRL_F8    = $6500;  CTRL_F9    = $6600;
  CTRL_F10   = $6700;  CTRL_F11   = $8900;  CTRL_F12   = $8A00;

  ALT_F1     = $6800;  ALT_F2     = $6900;  ALT_F3     = $6A00;
  ALT_F4     = $6B00;  ALT_F5     = $6C00;  ALT_F6     = $6D00;
  ALT_F7     = $6E00;  ALT_F8     = $6F00;  ALT_F9     = $7000;
  ALT_F10    = $7100;  ALT_F11    = $8B00;  ALT_F12    = $8C00;

  CTRL_0     = $0B00;  CTRL_1     = $0200;  CTRL_2     = $0300;
  CTRL_3     = $0400;  CTRL_4     = $0500;  CTRL_5     = $0600;
  CTRL_6     = $071E;  CTRL_7     = $0800;  CTRL_8     = $0900;
  CTRL_9     = $0A00;  CTRL_SZ    = $0C1F;  CTRL_APOST = $0D00;
  CTRL_BKSPC = $0E7F;
  CTRL_CR    = $1C0A;
  CTRL_A     = $1E01;  CTRL_B     = $3002;  CTRL_C     = $2E03;
  CTRL_D     = $2004;  CTRL_E     = $1205;  CTRL_F     = $2106;
  CTRL_G     = $2207;  CTRL_H     = $2308;  CTRL_I     = $1709;
  CTRL_J     = $240A;  CTRL_K     = $250B;  CTRL_L     = $260C;
  CTRL_M     = $320D;  CTRL_N     = $310E;  CTRL_O     = $180F;
  CTRL_P     = $1910;  CTRL_Q     = $1011;  CTRL_R     = $1312;
  CTRL_S     = $1F13;  CTRL_T     = $1414;  CTRL_U     = $1615;
  CTRL_V     = $2F16;  CTRL_W     = $1117;  CTRL_X     = $2D18;
  CTRL_Y     = $1519;  CTRL_Z     = $2C1A;

  ALT_ESC    = $0100;
  ALT_0      = $8100;  ALT_1      = $7800;  ALT_2      = $7900;
  ALT_3      = $7A00;  ALT_4      = $7B00;  ALT_5      = $7C00;
  ALT_6      = $7D00;  ALT_7      = $7E00;  ALT_8      = $7F00;
  ALT_9      = $8000;  ALT_SZ     = $8200;  ALT_APOST  = $8300;
  ALT_BKSPC  = $0E00;
  ALT_CR     = $1C00;
  ALT_A      = $1E00;  ALT_B      = $3000;  ALT_C      = $2E00;
  ALT_D      = $2000;  ALT_E      = $1200;  ALT_F      = $2100;
  ALT_G      = $2200;  ALT_H      = $2300;  ALT_I      = $1700;
  ALT_J      = $2400;  ALT_K      = $2500;  ALT_L      = $2600;
  ALT_M      = $3200;  ALT_N      = $3100;  ALT_O      = $1800;
  ALT_P      = $1900;  ALT_Q      = $1000;  ALT_R      = $1300;
  ALT_S      = $1F00;  ALT_T      = $1400;  ALT_U      = $1600;
  ALT_V      = $2F00;  ALT_W      = $1100;  ALT_X      = $2D00;
  ALT_Y      = $1500;  ALT_Z      = $2C00;

  ALT_SPC    = $3900;

  CTRL_UP    = $8D00;  CTRL_DOWN  = $9100;  CTRL_LEFT  = $7300;
  CTRL_RIGHT = $7400;  CTRL_HOME  = $7700;  CTRL_END   = $7500;
  CTRL_DEL   = $9300;  CTRL_INS   = $9200;

  IDE_INS      = $0500; IDE_DEL      = $0700;
  IDE_CTRL_INS = $0400; IDE_CTRL_DEL = $0600;
  IDE_ALT_SPC  = $0200;

  ALT_UP     = $9800;  ALT_DOWN   = $A000;  ALT_LEFT   = $9B00;
  ALT_RIGHT  = $9D00;


var
  KBDHead     : integer absolute $0000:$041A;
  KBDTail     : integer absolute $0000:$041C;
  KBDSeg      : KbdBuff absolute $0000:$041E;

function ScrlPressed : Boolean; function ScrlActive  : Boolean;
function NumPressed  : Boolean; function NumActive   : Boolean;
function CapsPressed : Boolean; function CapsActive  : Boolean;
function InsPressed  : Boolean; function InsActive   : Boolean;

function ShiftPressed: Boolean;
function LeftShiftPressed: Boolean;
function RightShiftPressed: Boolean;

function CtrlPressed : Boolean;
{ Original author: Max Maischein }
Inline(
$31/$F6/            {XOR    SI,SI        }
$8E/$C6/            {MOV    ES,SI        }
$26/                {ES:                 }
$A0/$17/$04/        {MOV    AL,[0417]    }
$A8/$04/            {TEST   AL,04        }
$B0/$01/            {MOV    AL,01        }
$75/$02/            {JNZ    $+2          }
$FE/$C8             {DEC    AL           }
);

function LeftCTRLPressed: Boolean;
function RightCTRLPressed: Boolean;

function ALTPressed : Boolean;
{ Original author: Max Maischein }
Inline(
$31/$F6/            {XOR    SI,SI        }
$8E/$C6/            {MOV    ES,SI        }
$26/                {ES:                 }
$A0/$17/$04/        {MOV    AL,[0417]    }
$A8/$08/            {TEST   AL,08        }
$B0/$01/            {MOV    AL,01        }
$75/$02/            {JNZ    $+2          }
$FE/$C8             {DEC    AL           }
);

function LeftALTPressed: Boolean;
function RightALTPressed: Boolean;

function  EnhancedKBDPresent : Boolean;
function  ExtendedKeysAllowed: Boolean;
procedure EnableExtendedKeys;
procedure DisableExtendedKeys;

function  KeyPressed : Boolean;
function  ReadKey : Char;
function  PeekKey : Char;
function  ReadKeyWord : Word;
function  PeekKeyWord : Word;

function  NormalKey : char; { like readkey, but excepts only normal keys }

procedure ClrKbd;                           { clear the keyboard buffer  }
procedure Char2KBD (ch:char;code:byte);     { put Char end extended code }
procedure Word2Kbd(w: Word);                { put Word to buffer         }

implementation

const
  NormalKeyExceptions = [#13,#27]; { Insert all chars < 32 to be excepted by
                                     NormalKey here }

var
  KBDFlag0   : Byte Absolute $40:$17;
  KBDFlag1   : Byte Absolute $40:$18;
  KBDFlag2   : Byte Absolute $40:$97;
  KBDFlag3   : Byte Absolute $40:$96;

  keyCmd,                  { "base command" for int 16h }
  extKey      : Byte;      { buffer for extended keys   }

function ScrlPressed : Boolean;
{ Original author: Max Maischein }
begin ScrlPressed := (KBDFlag1 AND 16) <> 0; end;

function ScrlActive  : Boolean;
{ Original author: Max Maischein }
begin ScrlActive := (KBDFlag0 AND 16) <> 0; end;

function NumPressed : Boolean;
{ Original author: Max Maischein }
begin NumPressed := (KBDFlag1 AND 32) <> 0; end;

function NumActive   : Boolean;
{ Original author: Max Maischein }
begin NumActive := (KBDFlag0 AND 32) <> 0; end;

function CapsPressed : Boolean;
{ Original author: Max Maischein }
begin CapsPressed := (KBDFlag1 AND 64) <> 0; end;

function CapsActive  : Boolean;
{ Original author: Max Maischein }
begin CapsActive := (KBDFlag0 AND 64) <> 0; end;

function InsActive   : Boolean;
{ Original author: Max Maischein }
begin InsActive := (KBDFlag0 AND 128) <> 0; end;

function InsPressed : Boolean;
{ Original author: Max Maischein }
begin InsPressed := (KBDFlag1 AND 128) <> 0; end;

function LeftShiftPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin LeftShiftPressed:= (KBDFlag0 AND 2) <> 0; end;

function RightShiftPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin RightShiftPressed:= (KBDFlag0 AND 1) <> 0; end;

function ShiftPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin ShiftPressed:= RightShiftPressed OR LeftShiftPressed; end;

function LeftCTRLPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin LeftCTRLPressed:= (KBDFlag1 AND 1) <> 0; end;

function RightCTRLPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin RightCTRLPressed:= (KBDFlag3 AND 4) <> 0; end;

function LeftALTPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin LeftALTPressed:= (KBDFlag1 AND 2) <> 0; end;

function RightALTPressed: Boolean;
{ Original author: Orazio Czerwenka }
begin RightALTPressed:= (KBDFlag3 AND 8) <> 0; end;

{ ************************************************************************** }
{ ͸}
{  EnhancedKBDPresent : Boolean                                            }
{ ;}
function EnhancedKBDPresent : boolean; 
{ Original author: Max Maischein, Unit CRT2;
  modificatons by Orazio Czerwenka according to
  Martin Austermeier's Unit ReadKBD }
begin
  asm
    sub al, al
    mov [extKey], al    { init ReadKey }
    mov [keyCmd], al    { normal Cmd (0) }
    mov al, 0FFh
    mov ah, 12h         { get shift states :}
    int 16h
    cmp al, 0FFh        { shifts? }
    je  @@NoEnhKbd      { not supported -> }
    mov @result, 0h     { TRUE }
  @@NoEnhKbd:
    mov @result, 1h     { FALSE }
  end;
end;

{ ************************************************************************** }
{ ͸}
{  ExtendedKeysAllowed: Boolean                                            }
{ ;}
function ExtendedKeysAllowed: Boolean;
{ Original author: Orazio Czerwenka }
begin
  ExtendedKeysAllowed:= (keyCmd = $10);
end;

{ ************************************************************************** }
{ ͸}
{  EnableExtendedKeys                                                      }
{ ;}
procedure EnableExtendedKeys; 
{ Original author: Orazio Czerwenka }
begin
  if EnhancedKBDPresent then
  asm
    mov [keyCmd], 10h   { enhanced keyboard support }
  end;
end;

{ ************************************************************************** }
{ ͸}
{  DisableExtendedKeys                                                     }
{ ;}
procedure DisableExtendedKeys; assembler;
{ Original author: Orazio Czerwenka }
ASM
  mov [keyCmd], 0h   { disable enhanced keyboard support }
END;

{ ************************************************************************** }
{ ͸}
{  KeyPressed : Boolean                                                    }
{ ;}
function KeyPressed : Boolean; assembler;
{ Original author: Martin Austermeier }
ASM
  cmp [extKey], 0      { extended key pending? }
  jne @@True           { yes -> }
  mov ah, [keyCmd]     { 0/10 }
  inc ah               { keypressed function (01/11) }
  int 16h
  mov al, FALSE        { key available? }
  jz  @@Exit           { no -> }
@@True:
  mov al, TRUE
@@Exit:
END;  { KeyPressed }

{ ************************************************************************** }
{͸ }
{ ReadKey : Char;                                                          }
{; }
function ReadKey : Char; assembler;
{ Original author: Martin Austermeier }
ASM
  mov al, [extKey]     { get saved ext.key }
  mov [extKey], 0      { reset }
  or al, al            { previous = extended key? }
  jne @@End            { nope -> }
  mov ah, [keyCmd]     { read key }
  int 16h
  cmp al, 0E0h         { extended keyboard, cursor keys }
  jne @@NoE0           { no cursor key -> }
  or ah, ah            { "" (E0) allowed }
  jnz @@Ext
@@NoE0:
  or al, al            { LowByte=0? }
  jnz @@End            { no, valid key -> }
@@Ext:
  sub al, al           { return 0 }
  mov [extKey], AH     { save extended key }
@@End:
  xor ah, ah           { return AL only }
END;  { ReadKey }

{ ************************************************************************** }
{͸ }
{ PeekKey : Char;                                                          }
{; }
function PeekKey : Char; assembler;
{ Original author: Martin Austermeier,
  modifications made by Orazio Czerwenka
  based upon ReadKey }
ASM
  mov al, [extKey]     { get saved ext.key }
  mov [extKey], 0      { reset }
  or al, al            { previous = extended key? }
  jne @@End            { nope -> }
  mov ah, [keyCmd]     { read key }
  inc ah               { peek key instead }
  int 16h
  cmp al, 0E0h         { extended keyboard, cursor keys }
  jne @@NoE0           { no cursor key -> }
  or ah, ah            { "" (E0) allowed }
  jnz @@Ext
@@NoE0:
  or al, al            { LowByte=0? }
  jnz @@End            { no, valid key -> }
@@Ext:
  sub al, al           { return 0 }
  mov [extKey], AH     { save extended key }
@@End:
  xor ah, ah           { return AL only }
END;  { ReadKey }


{ ************************************************************************** }
{͸ }
{ ReadKeyWord : Word;                                                      }
{; }
function ReadKeyWord : Word; assembler;
{ Original author: Martin Austermeier
  modifications based upon ReadKey by
  Orazio Czerwenka }
ASM
  (*
  mov al, [extKey]     { get saved ext.key }
  mov [extKey], 0      { reset }
  or al, al            { previous = extended key? }
  jne @@End            { nope -> }
  *)
  mov ah, [keyCmd]     { read key }
  int 16h
  cmp al, 0E0h         { extended keyboard, cursor keys }
  jne @@NoE0           { no cursor key -> }
  or ah, ah            { "" (E0) allowed }
  jnz @@Ext
@@NoE0:
  or al, al            { LowByte=0? }
  jnz @@End            { no, valid key -> }
@@Ext:
  sub al, al           { return 0 }
  mov [extKey], AH     { save extended key }
@@End:
(*  xor ah, ah           { return AL only }*)
END;  { ReadKey }

{ ************************************************************************** }
{͸ }
{ PeekKeyWord : Word;                                                      }
{; }
function PeekKeyWord : Word; assembler;
{ Original author: Martin Austermeier
  modifications based upon ReadKey by
  Orazio Czerwenka }
ASM
  (*
  mov al, [extKey]     { get saved ext.key }
  mov [extKey], 0      { reset }
  or al, al            { previous = extended key? }
  jne @@End            { nope -> }
  *)
  mov ah, [keyCmd]     { read key }
  inc ah               { peek key instead }
  int 16h
  cmp al, 0E0h         { extended keyboard, cursor keys }
  jne @@NoE0           { no cursor key -> }
  or ah, ah            { "" (E0) allowed }
  jnz @@Ext
@@NoE0:
  or al, al            { LowByte=0? }
  jnz @@End            { no, valid key -> }
@@Ext:
  sub al, al           { return 0 }
  mov [extKey], AH     { save extended key }
@@End:
(*  xor ah, ah           { return AL only }*)
END;  { ReadKey }


{ ************************************************************************** }

function NormalKey : char;
{ Original author: Max Maischein, Unit CRT2;
  modifications by Orazio Czerwenka }
var
  ch : word;
  b  : boolean;
begin
  b:= false;
  Repeat
  ch := word(readKey);
  If (lo(ch) <> 0) and ((lo(ch) > 31) or (chr(ch) in NormalKeyExceptions))
    then b:= true
    else ch:= word(readkey);
  Until b;
  if not (chr(ch) in NormalKeyExceptions)
    then NormalKey:= chr(lo(ch))
    else NormalKey:= #13;
end;

{ ************************************************************************** }

procedure ClrKbd; assembler;              { adapted of FLUSHKEY.PAS from    }
{ Modifications: Orazio Czerwenka }       { Borland-Net host, Langen        }
asm
  mov  ax, 0Ch
  shl  ax, 8
  or   ax, ax
  mov  dx, 00FFh
  int  21h
end;

{ ************************************************************************** }

procedure Char2Kbd(ch:char;code:byte);    { adapted of BUFSTUFF.PAS from    }
{ Modifications: Orazio Czerwenka }       { Borland-Net host, Langen        }
var                                       
  TmpTail : integer;
begin
   TmpTail:= KBDTail;                       { store the current end of buffer }
   KBDTail:= KBDTail + 2;                   { incriment to next position      }
   if KBDHead = KBDTail then                { if the buffer is full (?) ...   }
   begin
      KBDTail:= TmpTail;                    { ... restore the previous value  }
   end
   else
   begin
     KbdSeg[TmpTail]:= ord(ch);            { put ASCII value in buffer       }
     KbdSeg[TmpTail+1]:= code;             { put extended key code           }
     if KBDTail > 60                       { reached buffer's end ? ...      }
       then KBDTail:= 30;                  { ... wrap to first position !    }
   end;
end;

{ ************************************************************************** }

procedure Word2Kbd(w: Word);              { adapted of BUFSTUFF.PAS from    }
{ Modifications: Orazio Czerwenka }       { Borland-Net host, Langen        }
var                                       
  TmpTail : integer;
begin
   TmpTail:= KBDTail;                       { store the current end of buffer }
   KBDTail:= KBDTail + 2;                   { incriment to next position      }
   if KBDHead = KBDTail then                { if the buffer is full (?) ...   }
   begin
      KBDTail:= TmpTail;                    { ... restore the previous value  }
   end
   else
   begin
     KbdSeg[TmpTail]:= Lo(w);               { put ASCII value in buffer       }
     KbdSeg[TmpTail+1]:= Hi(w);             { put extended key code           }
     if KBDTail > 60                        { reached buffer's end ? ...      }
       then KBDTail:= 30;                   { ... wrap to first position !    }
   end;
end;

{ ************************************************************************** }
procedure InitFKBD;
begin
  DisableExtendedKeys;   { ensure TP compatibility by default }
end;

{$IFOPT O-}
begin
  InitFKBD;
{$ENDIF}
end.