{ FDRIVES.INC - include file for the PRUSSG unit FDOS to speed up and enhance
  drive related operations under DOS / implementation part }
 (***************************************************************************

         RELEASE 1.00 - as first contained in the file PRUS101.LZH
                by Orazio Czerwenka, 2:2450/540.55, GERMANY

               --------------------------------------------
                organized for Fido's PASCAL related echoes    
               --------------------------------------------

     09/06/1994 to --/--/---- by Orazio Czerwenka, 2:2450/540.55, GERMANY



           As far as third party copyrights are not violated this
           source code is hereby placed to the public domain. Use
           it whatever way you want, but use AT YOUR OWN RISK.

           In case you should modify the source rather send your
           modifications to the unit's current organizer (see above for
           NM address) than to spread it on your own. This will help to
           keep the unit updated and grant a certain standard to all
           other users as well.

           The unit is currently still under work. So it might greatly
           benefit of your participation.

           Those who contributed to the following piece of source,
           listed in alphabethical order:
        ================================================================
           Orazio Czerwenka, Andrew Eigus, Peter Schuette ...
        ================================================================
           YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

           Credits in your own programs are as welcome as unnecessary.

         Special thanks to Andrew Eigus (2:5100/33, Latvia) who greatly
          supported this piece of source by contributing a special PD
                         version of his Unit ENHDOS.

 ***************************************************************************)

{ -------------------------------------------------------------------------- }

Function GetVerify; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV AH,54H
  INT 21h
End; { GetVerify }

{ -------------------------------------------------------------------------- }

Function SetVerify; assembler;
{ Original author: Andrew Eigus }
Asm
  CALL GetVerify
  PUSH AX
  MOV AL,Verify
  MOV AH,2EH
  INT 21h
  POP AX
End; { SetVerify }

{ -------------------------------------------------------------------------- }

Function GetCurDisk; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV AH,19h
  INT 21h
End; { GetCurDisk }

{ -------------------------------------------------------------------------- }

Function SetCurDisk; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV AH,0Eh
  MOV DL,Drive
  INT 21h
End; { SetCurDisk }

{ -------------------------------------------------------------------------- }

Procedure GetDriveAllocInfo; assembler;
{ Original author: Andrew Eigus }
Asm
  PUSH DS
  MOV AH,1Ch
  MOV DL,Drive
  INT 21h
  MOV AH,BYTE PTR [DS:BX]
  POP DS
  LES DI,Info
  CLD
  XCHG AH,AL
  STOSB  { store Info.FATId }
  XCHG AX,DX
  STOSW  { store Info.Clusters }
  XCHG AL,DH
  STOSB  { store Info.SectPerClust }
  XCHG AX,CX
  STOSW  { store Info.SectSize }
End; { GetDriveAllocInfo }

{ -------------------------------------------------------------------------- }

Function GetDPB; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV DOSResult,dosrOk
  PUSH DS
  MOV AH,32h
  MOV DL,Drive
  INT 21h
  MOV WORD PTR [DPB],DS
  MOV WORD PTR [DPB+2],BX
  POP DS
  XOR AH,AH
  CMP AL,0FFh
  JNE @@1
  MOV DOSResult,dosrInvalidDrive
  PUSH DOSResult
  {$IFOPT G+}
  PUSH fnGetDPB { store function code }
  {$ELSE}
  MOV AX,fnGetDPB
  PUSH AX
  {$ENDIF}
  CALL ErrorHandler
  MOV AX,DOSResult
  NEG AX
@@1:
End; { GetDPB }

{ -------------------------------------------------------------------------- }

Function DiskSize; assembler;
{ Original author: Andrew Eigus }
Asm
@@1:
  MOV DOSResult,dosrOk
  MOV AH,36h
  MOV DL,Drive
  INT 21h
  CMP AX,0FFFFh
  JE  @@2
  MOV BX,DX
  IMUL CX
  IMUL BX
  JMP @@3
@@2:
  MOV DOSResult,dosrInvalidDrive
  PUSH DOSResult
  {$IFOPT G+}
  PUSH fnGetDiskSize { store function code }
  {$ELSE}
  MOV AX,fnGetDiskSize
  PUSH AX
  {$ENDIF}
  CALL ErrorHandler
  CMP AL,frRetry
  JE  @@1
  MOV AX,DOSResult
  NEG AX
  XOR DX,DX
@@3:
End; { DiskSize }

{ -------------------------------------------------------------------------- }

Function DiskFree; assembler;
{ Original author: Andrew Eigus }
Asm
@@1:
  MOV DOSResult,dosrOk
  MOV AH,36h
  MOV DL,Drive
  INT 21h
  CMP AX,0FFFFh
  JE  @@2
  IMUL CX
  IMUL BX
  JMP @@3
@@2:
  MOV DOSResult,dosrInvalidDrive
  PUSH DOSResult
  {$IFOPT G+}
  PUSH fnGetDiskFree { store function code }
  {$ELSE}
  MOV AX,fnGetDiskFree
  PUSH AX
  {$ENDIF}
  CALL ErrorHandler
  CMP AL,frRetry
  JE  @@1
  MOV AX,DOSResult
  NEG AX
  XOR DX,DX
@@3:
End; { DiskFree }

{ -------------------------------------------------------------------------- }

Function IsFixedDrive; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV DOSResult,dosrOk
  MOV AX,4408h
  MOV BL,Drive
  INT 21h
  JNC @@1
  MOV DOSResult,AX { save error code in global variable }
  PUSH AX     { store error code }
  {$IFOPT G+}
  PUSH fnIsFixedDrive { store function code }
  {$ELSE}
  MOV AX,fnIsFixedDrive
  PUSH AX
  {$ENDIF}
  CALL ErrorHandler
@@1:
End; { IsFixedDrive }

{ -------------------------------------------------------------------------- }

Function IsNetworkDrive; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV DOSResult,dosrOk
  MOV AX,4409h
  MOV BL,Drive
  INT 21h
  JNC @@1
  MOV DOSResult,AX { save error code in global variable }
  PUSH AX     { store error code }
  {$IFOPT G+}
  PUSH fnIsNetworkDrive { store function code }
  {$ELSE}
  MOV AX,fnIsNetworkDrive
  PUSH AX
  {$ENDIF}
  CALL ErrorHandler
@@1:
End; { IsNetworkDrive }

{ -------------------------------------------------------------------------- }

Function IsCDROMDrive; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV AX,1500h
  XOR BX,BX
  INT 2Fh
  XOR CL,CL { MOV CL,False }
  OR  BX,0    { not a best solution, works onley with MSCDEX CD-ROM v2.00+ }
  JZ  @@1
  MOV AX,150Bh
  XOR CH,CH
  MOV CL,Drive
  INT 2Fh
  XOR CL,CL { MOV CL,False }
  CMP BX,0ADADh
  JNE @@1
  OR  AX,0
  JZ  @@1
  INC CL { MOV CL,True }
@@1:
  MOV AL,CL
End; { IsCDROMDrive }

{ -------------------------------------------------------------------------- }

Function IsCompressedDrive; assembler;
{ Original author: Andrew Eigus }
Asm
  MOV AX,4A11h
  MOV BX,1
  MOV DL,Drive
  INT 2Fh
  XOR CL,CL { MOV CL,False }
  OR  AX,0  { is DoubleSpace loaded? }
  JNZ @@1
  CMP DL,BL { if a host drive equal to compressed, then get out... }
  JE  @@2
  TEST BL,10000000b { bit 7=1: DL=compressed,BL=host
                           =0: DL=host,BL=compressed }
  JZ  @@2           { so avoid host drives, assume host=fixed :) }
  CMP Drive,DL
  JNE @@2
@@1:
  INC CL { MOV CL,True }
@@2:
  MOV AL,CL
End; { IsCompressedDrive }

{ -------------------------------------------------------------------------- }

Function GetDriveType(Drive : byte) : byte; assembler;
{ Original author: Andrew Eigus }
Asm
  CMP Drive,0
  JNE @@1
  CALL GetCurDisk
  MOV Drive,AL
  INC Drive
@@1:
  PUSH WORD PTR Drive
  CALL IsCDROMDrive
  OR  AL,False
  JZ  @@2
  MOV AL,dtCDROM
  JMP @@7
@@2:
  MOV AL,Drive
  DEC AL
  PUSH AX
  CALL IsCompressedDrive
  OR  AL,False
  JZ  @@3
  MOV AL,dtCompressed
  JMP @@7
@@3:
  PUSH WORD PTR Drive
  CALL IsNetworkDrive
  XOR BL,BL  { MOV BL,False }
  CMP DOSResult,dosrOk
  JNE @@6
  OR  AL,False
  JZ  @@4
  MOV AL,dtRemote
  JMP @@7
@@4:
  PUSH WORD PTR Drive
  CALL IsFixedDrive
  XOR BL,BL
  CMP DOSResult,dosrOk
  JNE @@6
  OR  AL,False
  JZ  @@5
  MOV AL,dtFixed
  JMP @@7
@@5:
  MOV BL,dtRemovable
@@6:
  MOV AL,BL
@@7:
End; { GetDriveType }

{ -------------------------------------------------------------------------- }

Function LogicalDrives;
{ Mailed in by Peter Schuette }
Const MaxDrives : ARRAY[1..26] Of Char ='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
Var Regs : Registers;
    i : Byte;
    Drives : String[26];
Begin {LogicalDrives}
  Drives := '';

  For i := 1 To 26 Do Begin
    Regs.AH := $44;  {DOS function $44}
    Regs.AL := $09;  {subfunction $09}
    Regs.BL := i;  {drive number}
    MsDos(Regs);
    If (FCarry And Regs.Flags) = 0 Then Drives := Drives + MaxDrives[i];
  End;
  Regs.AX := $0;
  LogicalDrives := Drives;
End{LogicalDrives};

{ -------------------------------------------------------------------------- }

function DriveExists(drive: char) : boolean;
{ Original author: Orazio Czerwenka }
var
  s  : string;
  b  : boolean;
  i  : integer;
  ch : char;
begin
  b:= FALSE;
  s:= LogicalDrives;
  i:= 1;
  drive:= upcase(drive);
  while not (i > length(s)) and (b= false) do begin
    b:= (drive= s[i]);
    inc(i);
  end;
  DriveExists:= b;
end;

{ -------------------------------------------------------------------------- }

{
 Changes
 =======
 in 1.00
 -------
09/06/1994 -ocz The following routines have been implemented from Andrew
                Eigus' unit ENHDOS:
                GetVerify, SetVerify, GetCurDisk, SetCurDisk, GetDrive-
                AllocInfo, GetDPB, DiskSize DiskFree, IsFixedDisk,
                IsNetworkDrive, IsCDROMDrive, IsCompressedDrive,
                GetDriveType
           -ocz IsFixedDisk renamed to IsFixedDrive
           -ocz LogicalDrives moved from FDOS.PAS to FDRIVES.DEC/INC.
}