unit FConfig;

 { FIDO unit to Read text Configs like the configs of xOR or Reqman
 (*************************************************************************)

	 RELEASE 1.00 - as first contained in the file PRUS101.LZH
		by Matthias Tichy, 2:2440/210.14, GERMANY

	       --------------------------------------------
		organized for Fido's PASCAL related echoes
	       --------------------------------------------

     21/11/1994 to --/--/---- by Matthias Tichy, 2:2440/210.14, GERMANY


	   As far as third party copyrights are not violated this
	   source code is hereby placed to the public domain. Use
	   it whatever way you want, but use AT YOUR OWN RISK.

	   In case you should modify the source rather send your
	   modifications to the unit's current organizer (see above for
	   NM address) than to spread it on your own. This will help to
	   keep the unit updated and grant a certain standard to all
	   other users as well.

	   The unit is currently still under work. So it might greatly
	   benefit of your participation.

	   Those who contributed to the following piece of source,
	   listed in alphabethical order:
	================================================================
        Matthias Tichy ...
	================================================================
	   YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

	   Credits in your own programs are as welcome as unnecessary.

(***************************************************************************}

{$I FDEFINE.DEF} { Use the general include file for conditional defines and
		   common compiler directives ... }

		 { ... and set the unit's specific defines aftwerwards. }

interface

const
  CFirst = true;
  CNext = false;

type
  PKette = ^TKette;
  TKette = record
             text : string;
             next : PKette;
           end;

  PConfig = ^RConfig;
  RConfig = record
              anfang, next : PKette;
            end;

function LoadConfig(name : string) : PConfig;
function ReadEntry(var entry : string;conf : PConfig;first : boolean) : integer;
procedure DisposeConfig(var conf : PConfig);

implementation

uses dos, fstr;

function FileExists(FileName: string; attr : Word) : Boolean;

var
  f: SearchRec;

begin
  findfirst(Filename, attr, f);
  if doserror = 0 then Fileexists := true else Fileexists := false;
end;

function LoadConfig(name : string) : PConfig;

var
  f : text;
  Conf : PConfig;
  Kette : PKette;
  dummy : string;

begin
  if not fileexists(name, anyfile) then
    begin
      LoadConfig := nil;
      exit;
    end;
  New(Conf);
  conf^.next := nil;
  conf^.anfang := New(PKette);
  Kette := Conf^.anfang;
  Kette^.next := nil;
  filemode := 64;
  assign(f, name);
  reset(f);
  while not eof(f) do
    begin
      readln(f, dummy);
      dummy := stripLeadingSpaceTab(dummy);
      if (dummy <> '') and (dummy[1] <> ';') then
        begin
          kette^.text := dummy;
          if not eof(f) then
            begin
              New(kette^.next);
              kette := kette^.next;
              kette^.next := nil;
            end;
        end;
    end;
  close(f);
  LoadConfig := Conf;
end;

function readEntry(var entry : string;Conf : PConfig;first : boolean) : Integer;

var
  dummy : string;
  anfang : PKette;

begin
  entry := upperstring(entry);
  if first then
    anfang := conf^.anfang
  else anfang := conf^.next;
  repeat
    dummy := anfang^.text;
    dummy := copy(dummy, 1, pos(' ',dummy)-1);
    dummy := upperstring(dummy);
    if dummy <> entry then anfang := anfang^.next;
  until (anfang = nil) or (dummy = entry);
  if dummy = entry then
    begin
      dummy := anfang^.text;
      entry := copy(dummy, pos(' ',dummy)+1, length(dummy)-pos(' ',dummy));
      entry := StripLeadingSpaceTab(entry);
      readEntry := 0;
    end
  else readEntry := -1;
  conf^.next := anfang^.next;
end;

procedure DisposeConfig(var conf : PConfig);

var
  kette, kette2 : PKette;

begin
  kette := conf^.anfang;
  Dispose(conf);
  while Kette <> nil do
    begin
      kette2 := kette^.next;
      dispose(kette);
      kette := kette2;
    end;
  conf := nil;
end;

end.