Unit FDPMI; { routines for DOS/DPMI communication }
 (***************************************************************************

           RELEASE 1.00 - as contained in the file PRUS100.LZH
                 by Max Maischein, 2:244/1106.17, GERMANY

               --------------------------------------------
                organized for Fido's PASCAL related echoes
               --------------------------------------------

     06/15/1994 to --/--/---- by Max Maischein, 2:244/1106.17, GERMANY

           As far as third party copyrights are not violated this
           source code is hereby placed to the public domain. Use
           it whatever way you want, but use AT YOUR OWN RISK.

           In case you should modify the source rather send your
           modifications to the unit's current organizer (see above for
           NM address) than to spread it on your own. This will help to
           keep the unit updated and grant a certain standard to all
           other users as well.

           The unit is currently still under work. So it might greatly
           benefit of your participation.

           Those who contributed to the following piece of source,
           listed in alphabethical order:
        ================================================================
           Jochen Magnus (SEGDEMO.PAS), Max Maischein (collecting,
           documenting, testing etc.), Raphael Vanney (program CHARSET
           .PAS)
        ================================================================
           YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

 ***************************************************************************)

{$I FDEFINE.DEF}

Interface

Type TRealModeRegs  =
     Record
          Case Integer Of
          0: ( EDI, ESI, EBP, EXX, EBX, EDX, ECX, EAX: Longint;
               Flags, ES, DS, FS, GS, IP, CS, SP, SS: Word) ;
          1: ( DI,DIH, SI, SIH, BP, BPH, XX, XXH: Word;
               Case Integer of
                 0: (BX, BXH, DX, DXH, CX, CXH, AX, AXH: Word);
                 1: (BL, BH, BLH, BHH, DL, DH, DLH, DHH,
                     CL, CH, CLH, CHH, AL, AH, ALH, AHH: Byte));
     End;
(* Use these and RealModeInt() instead of Registers and Intr() under DPMI *)

Type TLongRec = Record
       Case Byte of
         0 : ( L : LongInt );
         1 : ( wLo : Word;
               wHi : Word; );
         2 : ( iLo : Integer;
               iHi : Integer );
     End;

Function RealModeInt( IntNo : Byte; Var RealRegs : TRealModeRegs) : Boolean;
(* Replacement for Intr(), returns False on error *)

Function NewSelector( Base, Limit : Longint) : Word;
(* Returns a new selector for the range [Base - (Base+Limit)]        *)
(* Base is the linear address of the memory location you want to use *)
(* You must free this selector after use with FreeSelector()         *)

Function AllocateLowMem( Size : Word; var PMPointer : Pointer ) : Word;
(* Allocates some memory in the first MB *)
(* Returns a pointer to it and a segment to pass to the real mode routine *)

Procedure FreeLowMem(Var PMPointer : Pointer );
(* Frees memory allocated with AllocateLowMem() *)

Implementation
Uses WinAPI;

Function RealModeInt( IntNo : Byte; Var RealRegs : TRealModeRegs) : Boolean;
Assembler;
{ This function switches to real mode and issues the specified interrupt,
  after filling the registers with values stored in RealRegs.
  If SS/SP as specified in RealRegs are Nil, the DPMI server provides a
  small stack. For more discution of this, see Ralf Brown's INTERxx.ZIP }
Asm
                        mov     ax, 0300h       { DPMI function "simulate real
mode int" }
                        mov     bl, [IntNo]
                        xor     bh, bh          { 0 as requested by DPMI v1.0 }
                        xor     cx, cx          { bytes to copy onto "remote"
stack }
                        les     di, [RealRegs]
                        int     31h             { Returns CF set on error }
                        mov     ax, 1           { assume everything went OK }
                        sbb     ax, 0           { if carry set, decrement ax }
                                                { to signal an error }
End;

Function NewSelector(Base,Limit:longint) : Word;
Var Sel : Word;
Begin
  Sel := AllocSelector(0);
  If (sel<>0) and (setSelectorBase(sel,base)=sel) and (setSelectorLimit(sel,
limit)=0)
    then newSelector:=sel
    else newSelector:=0;
End;

Function AllocateLowMem( Size : Word; var PMPointer : Pointer ) : Word;
{ This procedure allocates memory in the first megabyte, and returns two
  ways of accessing it : a pointer valid in protected mode, and the
  segment part of a pointer valid in real mode ; offset part is always 0 }

Var  Adr  : LongInt ;
Begin
  Adr:=GlobalDOSAlloc(Size) ;
  If Adr=0 then RunError( 0 );
  PMPointer := Ptr( TLongRec(Adr).wLo, 0);
  AllocateLowMem := TLongRec(Adr).wHi;
End ;

Procedure FreeLowMem(Var PMPointer : Pointer ) ;
{ Frees memory allocated with AllocateLowMem }
Begin
  GlobalDOSFree(Seg( PMPointer^ ));
  PMPointer := nil;
End ;
{$IFnDEF DPMI}
{$IFnDEF Windows}
  You are compiling WHAT ??
{$ENDIF}
{$ENDIF}
End.