Unit FDOS; { FIDO unit for DOS related stuff }
 (***************************************************************************

          RELEASE 1.02 - as first included in the file PRUS101.LZH
                by Orazio Czerwenka, 2:2450/540.55, GERMANY

               --------------------------------------------
                organized for Fido's PASCAL related echoes    
               --------------------------------------------

     05/22/1994 to --/--/---- by Orazio Czerwenka, 2:2450/540.55, GERMANY


           As far as third party copyrights are not violated this
           source code is hereby placed to the public domain. Use
           it whatever way you want, but use AT YOUR OWN RISK.

           In case you should modify the source rather send your
           modifications to the unit's current organizer (see above for
           NM address) than to spread it on your own. This will help to
           keep the unit updated and grant a certain standard to all
           other users as well.

           The unit is currently still under work. So it might greatly
           benefit of your participation.

           Those who contributed to the following piece of source,
           listed in alphabethical order:
        ================================================================
           Andrew Eigus, Keld R. Hansen ...
        ================================================================
           YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

           Credits in your own programs are as welcome as unnecessary.

         Special thanks to Andrew Eigus (2:5100/33, Latvia) who greatly
          supported this piece of source by contributing a special PD
                         version of his Unit ENHDOS.

 ***************************************************************************)

{$I FDEFINE.DEF}

interface

uses
  dos,
  FSTR                  { EnsureBackSlash for FileOnPath }
  ;

const
  { Error handler function (fr) result codes }

  frOk    = 0; { Continue program }
  frRetry = 1; { Retry function once again }

  { Function codes (only passed to error handler routine) (fn) constants }

  fnGetDPB         = $3200;
  fnGetDiskSize    = $3600;
  fnGetDiskFree    = $3601;
  fnGetCountryInfo = $3800;
  fnSetDate        = $2B00;
  fnSetTime        = $2D00;
  fnIsFixedDrive   = $4408;
  fnIsNetworkDrive = $4409;
  fnCreateDir      = $3900;
  fnRemoveDir      = $3A00;
  fnGetCurDir      = $4700;
  fnSetCurDir      = $3B00;
  fnDeleteFile     = $4100;
  fnRenameFile     = $5600;
  fnGetFileAttr    = $4300;
  fnSetFileAttr    = $4301;
  fnFindFirst      = $4E00;
  fnFindNext       = $4F00;
  fnCreateFile     = $5B00;
  fnCreateTempFile = $5A00;
  fnOpenFile       = $3D00;
  fnDupHandle      = $4500;
  fnForceDup       = $4600;
  fnRead           = $3F00;
  fnWrite          = $4000;
  fnFlush          = $6800;
  fnSeek           = $4200;
  fnGetFDateTime   = $5700;
  fnSetFDateTime   = $5701;
  fnCloseFile      = $3E00;
  fnMemAlloc       = $4800;
  fnMemFree        = $4900;
  fnMemRealloc     = $4A00;

  { DOS 3.x+ errors/return codes }

  dosrOk                = 0;     { Success }
  dosrInvalidFuncNumber = 1;     { Invalid DOS function number }
  dosrFileNotFound      = 2;     { File not found }
  dosrPathNotFound      = 3;     { Path not found }
  dosrTooManyOpenFiles  = 4;     { Too many open files }
  dosrFileAccessDenied  = 5;     { File access denied }
  dosrInvalidFileHandle = 6;     { Invalid file handle }
  dosrMemCtlBlksKilled  = 7;     { Memory control blocks destroyed }
  dosrNotEnoughMemory   = 8;     { Not enough memory }
  dosrInvalidEnvment    = 10;    { Invalid environment }
  dosrInvalidFormat     = 11;    { Invalid format }
  dosrInvalidAccessCode = 12;    { Invalid file access code }
  dosrInvalidDrive      = 15;    { Invalid drive number }
  dosrCantRemoveDir     = 16;    { Cannot remove current directory }
  dosrCantRenameDrives  = 17;    { Cannot rename across drives }
  dosrNoMoreFiles       = 18;    { No more files }
  dosrFCB29Error        = $FF29; { Fn 29h: Invalid drive ID in filespec }
  dosrFCB11Error        = $FF11; { Fn 11h: No matching files }

type
  { Error handler function }

  TErrorFunc = function(ErrCode : integer; FuncCode : word) : byte;

var
  DOSResult : integer; { Error status variable }

function execute(Name : PathStr ; Tail : ComSTR) : Word;

{$I FFILES.DEC}
{$I FDRIVES.DEC}

implementation

var
  ErrorHandler : TErrorFunc;

{ -------------------------------------------------------------------------- }

PROCEDURE ReallocateMemory(P : POINTER); ASSEMBLER;
ASM                                                { used by Execute }
  MOV  AX, PrefixSeg
  MOV  ES, AX
  MOV  BX, WORD PTR P+2
  CMP  WORD PTR P,0
  JE   @OK
  INC  BX

 @OK:
  SUB  BX, AX
  MOV  AH, 4Ah
  INT  21h
  JC   @X
  LES  DI, P
  MOV  WORD PTR HeapEnd,DI
  MOV  WORD PTR HeapEnd+2,ES

 @X:
END;

FUNCTION EXECUTE(Name : PathStr ; Tail : ComSTR) : WORD; ASSEMBLER;
{ Original author: Keld R. Hansen }
ASM
  {$IFDEF CPU386}
  DB      66h
  PUSH    WORD PTR HeapEnd
  DB      66h
  PUSH    WORD PTR Name
  DB      66h
  PUSH    WORD PTR Tail
  DB      66h
  PUSH    WORD PTR HeapPtr
  {$ELSE}
  PUSH    WORD PTR HeapEnd+2
  PUSH    WORD PTR HeapEnd
  PUSH    WORD PTR Name+2
  PUSH    WORD PTR Name
  PUSH    WORD PTR Tail+2
  PUSH    WORD PTR Tail
  PUSH    WORD PTR HeapPtr+2
  PUSH    WORD PTR HeapPtr
  {$ENDIF}
  CALL ReallocateMemory
  CALL SwapVectors
  CALL DOS.EXEC
  CALL SwapVectors
  CALL ReallocateMemory
  MOV  AX, DosError
  OR   AX, AX
  JNZ  @OUT
  MOV  AH, 4Dh
  INT  21h

 @OUT:
END;

{ -------------------------------------------------------------------------- }

{$I FFILES.INC}
{$I FDRIVES.INC}

{ -------------------------------------------------------------------------- }


{$IFnDEF OVERLAYS}
BEGIN
{$ENDIF}

END.