{_INTEGRI.PAS   - (c) Ansgar Scherp, Joachim Gelhaus
  All rights reserved / vt'95 }

CONST
  ok = True ;  fehler = False ;
  esc = #27 ;  null = #0      ;
  fst_sekt     = 16           ;
  stdid        = 'CD001'      ;
  xa_id        = 'CD-XA001'   ;
  hsfs         = 'CDROM'      ;
  boot_rec     = 0            ;
  prim_dtyp    = 1            ;
  suppl_dtyp   = 2            ;
  part_dtyp    = 3            ;
  vd_term      = 255          ;
  d_char = [ 'A'..'Z','0'..'9','_'];

TYPE
  ptr_sector = ^sector;  sector  = Array[1..2048] of Byte;
  ptr_drec  = ^raw_rec;  raw_rec = Array[1..256] of Byte;
  isoidtyp  = Array[1..128] of Char;  isoidptr = ^isoidtyp;
  ptr_prim_vd = ^iso_p_descriptor;
  vd_datime = Record
    datime : Array[1..16] of Char;
    gmt    : ShortInt                     { -48 .. +52}
  End;
  iso_p_descriptor = Record     { Primary Volume Descriptor }
    VD_typ         : Byte                ;
    std_id         : Array[1..5] of Char ;
    vd_vers        : Byte                ;
    unused1        : Byte                ;
    sys_id         : Array[1..32] of Char;
    vol_id         : Array[1..32] of Char;
    unused8        : Array[1..8]  of Byte;
    vol_spc_sizeL  : LongInt             ;
    vol_spc_sizeM  : LongInt             ;
    unused32       : Array[1..32] of Byte;
    vol_set_sizeL  : Word                ;
    vol_set_sizeM  : Word                ;
    vol_seq_nrL    : Word                ;
    vol_seq_nrM    : Word                ;
    log_blc_sizeL  : Word                ;
    log_blc_sizeM  : Word                ;
    pth_tb_sizeL   : LongInt             ;
    pth_tb_sizeM   : LongInt             ;
    typ_L_path_tb  : LongInt             ;
    opt_L_path_tb  : LongInt             ;
    typ_M_path_tb  : LongInt             ;
    opt_M_path_tb  : LongInt             ;
    root_dir_rec   : Array[1..34] of Byte;
    vol_set_id,
    publ_id,
    data_prep_id,
    appl_id        : Array[1..128]of Char;
    c_file_id      : Array[1..37] of Char;
    abstr_file_id  : Array[1..37] of Char;
    bibl_file_id   : Array[1..37] of Char;
    vol_creat_datime,
    vol_mod_datime,
    vol_expi_datime,
    vol_eff_datime : vd_datime           ;
    file_struct_ver: Byte                ;
    reserved1      : Byte                ;
    app_use        : Array[1..141] of Byte;

    xa_sign        : Array[1..8] of Char ;
    xa_flags       : Word                ;
    startup_dir    : Array[1..8] of Char ;
    reserved8      : Array[1..8] of Byte ;

    reserved1000   : Array[1051..2048] of Byte;
  End;{isopdescriptor}

  boot_record = Record
    vd_typ         : Byte                ;
    std_id         : Array[1..5] of Char ;
    vd_vers        : Byte                ;
    sys_id         : Array[1..32] of Char;
    boot_id        : Array[1..32] of Char;
    sys_use        : Array[1..1977]of Byte;
  End;{bootrecord}

  vol_partition_descriptor = Record
    vd_typ         : Byte                ;
    std_id         : Array[1..5] of Char ;
    vd_vers        : Byte                ;
    dummy          : Byte                ;
    sys_id         : Array[1..32] of Char;
    part_id        : Array[1..32] of Char;
    part_locL      : LongInt             ;
    part_locM      : LongInt             ;
    sizeL          : LongInt             ;
    sizeM          : LongInt             ;
    reserved       : Array[1..1960]of Byte;
  End;{volpartdescrpt}

  ptr_dir_rec = ^directory_record;
  dr_datime = Record
    datime : Array[1..6] of Byte;
    gmt    : ShortInt                         { -48 .. +52}
  End;
  directory_record = Record
    len_dr         : Byte                ;
    len_ar         : Byte                ;
    loc_extentL    : LongInt             ;
    loc_extentM    : LongInt             ;
    len_dataL      : LongInt             ;
    len_dataM      : LongInt             ;
    rec_datime     : dr_datime           ;
    file_flags     : Byte                ;
    unit_size      : Byte                ;
    interl_gap_size: Byte                ;
    vol_sequ_numL  : Integer             ;
    vol_sequ_numM  : Integer             ;
    len_fi         : Byte                ;
    file_name      : Array[1..223] of Char;
  End;{directoryRecord}

  ptr_xa_dir = ^xa_dir_extens;
  xa_dir_extens = Record
    ow_id          : Integer             ;
    grp_id         : Integer             ;
    attr           : Word                ;
    sign           : Array[1..2] of Char ;
    file_num       : Byte                ;
    reserved       : Array[1..5] of Byte ;
  End;{xa-Extension}

  ptr_pt_rec = ^path_table_record;
  path_table_record = Record
    len_di         : Byte                ;
    len_ar         : Byte                ;
    loc_ext        : LongInt             ;
    parent_dir_num : Integer             ;
    dir_name       : Array[1..32] of Char;
  End;{pathtable}

VAR prim_vd : ptr_prim_vd;


FUNCTION pstr( pvd : isoidptr; strlen : Byte ) : String;
VAR sammel : String; i : Integer;
Begin
  sammel[0] := Char( strlen);
  i := 1;
  While (pvd^[i]<>null) and (i <= strlen) DO Begin
    sammel[i] := pvd^[i] ;
    Inc(i);
  End;{While}
  IF i < strlen Then sammel[0] := Char(i-1);
  i := length(sammel);
  While sammel[i] = ' ' Do Begin
    Dec(i);
    sammel[0] := Chr(i);
  End;
  pstr := sammel;
END;{pstr}

FUNCTION btst(by, bi : Byte) : Boolean;
Begin
  IF Odd( by Shr bi) Then btst := True
                     Else btst := False;
End;
FUNCTION bin(wert : LongInt; bits : Byte ) : String;
VAR i : Integer; c : String[32];
Begin
  c := '';
  For i := 1 to bits DO Begin
    IF odd(wert) Then c := '1' + c
                 Else c := '0' + c;
    wert := wert shr 1;
  End;{For}
  bin := c;
END;

FUNCTION lies_sekt(beginn : LongInt; s_anzahl : Integer ;
                            VAR puffer : sector) : Boolean;
VAR  regs : Registers;
Begin
  regs.ax := $1508;
  regs.CX := Ord(cd_lw)-65;
  regs.SI := beginn Shr 16;
  regs.DI := beginn Mod 65536;
  regs.DX := s_anzahl;
  regs.ES := Seg(puffer);
  regs.BX := Ofs(puffer);
  Intr($2F, regs);
  IF Odd(regs.Flags)=true Then Begin
      lies_sekt := fehler;
  End
  Else
    lies_sekt := ok;
END;


FUNCTION cd_iso_test(VAR prim_vd : ptr_prim_vd) : Boolean ;
Begin
  cd_iso_test := False;
  cd_iso := false;
  cd_name := '';
  IF lies_sekt(fst_sekt, 1, sector(prim_vd^)) = ok Then Begin
    IF pstr(@prim_vd^.std_id, 5) = stdid Then Begin
      cd_name := pstr(@prim_vd^.vol_id,32);
      cd_iso := true; { ISO-9660-CD-ROM }
      cd_iso_test := True;
    End{If stid}
  End;{IFok}
END;{cd-iso-test}

procedure CheckCDROM;
var buffer:string[20];
    regs:registers;
    hilfsb:word;
begin

  regs.ax:=$150D;
  regs.es:=seg(buffer[1]);
  regs.bx:=ofs(buffer[1]);
  intr($2F,regs);
  cd_lw:=chr(ord(buffer[1])+65);

  path:=paramstr(0);
  act_lw:=path[1];
  hilfsb:=0;
  while pos('\',copy(path,length(path)-hilfsb,1))=0 do inc(hilfsb);
  path:=(copy(path,1,length(path)-hilfsb-1));
  chDir(path);

  New(prim_vd);
  if cd_iso_test(prim_vd) = ok then begin end;
  Dispose(prim_vd);
  writeln('CD-ROM-DRIVE   :', cd_lw);
  writeln('CD-ROM-NAME    :', cd_name);
  writeln('CD-ROM-ISO9660 :', cd_iso);
  writeln('CURRENT_DRIVE  :', act_lw);

end;



