{---------------------------------------------------------------------------}
procedure init_colors;
var x:byte;
    f:file;
    reihe:array[1..3] of byte;
begin
  assign(f,'tisch'+tnr+'\t'+tnr+'-pal.pal');
  {$I-}
  reset(f,1);
  {$I+}
  for x:=0 to 255 do
  begin
    blockread(f,reihe,sizeof(reihe));
    pal[x].r := reihe[1];
    pal[x].g := reihe[2];
    pal[x].b := reihe[3];
  end;
  close(f);
  set_rgb_color(led_color_1,20,0,0);
  pal[led_color_1].r := 20;
  pal[led_color_1].g := 0;
  pal[led_color_1].b := 0;
  set_rgb_color(led_color_2,255,0,0);
  pal[led_color_2].r := 255;
  pal[led_color_2].g := 0;
  pal[led_color_2].b := 0;

  if tnr='1' then begin
    set_rgb_color($10,33,33,33);
    pal[$10].r := 33; pal[$10].g := 33; pal[$10].b := 33;
    set_rgb_color($11,35,35,35);
    pal[$11].r := 35; pal[$11].g := 35; pal[$11].b := 35;
    set_rgb_color($12,37,37,37);
    pal[$12].r := 37; pal[$12].g := 37; pal[$12].b := 37;
    set_rgb_color($13,39,39,39);
    pal[$13].r := 39; pal[$13].g := 39; pal[$13].b := 39;
    set_rgb_color($14,42,42,42);
    pal[$14].r := 42; pal[$14].g := 42; pal[$14].b := 42;
    set_rgb_color($15,52,52,52);
    pal[$15].r := 52; pal[$15].g := 52; pal[$15].b := 52;
    set_rgb_color($19,33,33,33);
    pal[$19].r := 33; pal[$19].g := 33; pal[$19].b := 33;
  end;

   if tnr='2' then begin
    set_rgb_color(170,33,33,33);
    pal[170].r := 33; pal[170].g := 33; pal[170].b := 33;
    set_rgb_color(171,35,35,35);
    pal[171].r := 35; pal[171].g := 35; pal[171].b := 35;
    set_rgb_color(172,37,37,37);
    pal[172].r := 37; pal[172].g := 37; pal[172].b := 37;
    set_rgb_color(173,39,39,39);
    pal[173].r := 39; pal[173].g := 39; pal[173].b := 39;
    set_rgb_color(174,42,42,42);
    pal[174].r := 42; pal[174].g := 42; pal[174].b := 42;
    set_rgb_color(175,52,52,52);
    pal[175].r := 52; pal[175].g := 52; pal[175].b := 52;
    set_rgb_color(176,33,33,33);
    pal[176].r := 33; pal[176].g := 33; pal[176].b := 33;
  end;

  for x := 255 downto 0 do set_rgb_color(x,pal[x].r,pal[x].g,pal[x].b);
end;

procedure load_table_tab;
var f:file;
    x,y:integer;
    reihe:array[0..319] of byte;
    t : byte;
begin
  for t := 0 to 255 do set_rgb_color(t,0,0,0);
  assign(f,'tisch'+tnr+'\t'+tnr+'-tab.org'{clb});
  reset(f,1);
  y:=48;
  repeat
    blockread(f,reihe,sizeof(reihe));
    for x:= 0 to 319 do put_pixel(x,y,reihe[x]);
    inc(y);
  until y >= 600+48;
  close(f);
end;

procedure load_table_gro;
var f:file;
    x,y:word;
    reihe : array[0..319] of byte;

begin
  assign(f,'tisch'+tnr+'\t'+tnr+'-gro.clb');
  reset(f,1);
  for y:=0 to 199 do begin
      blockread(f,reihe,sizeof(reihe));
      for x:=0 to 319 do tableground1^[x,y]:=reihe[x];
    end;

  for y:=200 to 399 do begin
      blockread(f,reihe,sizeof(reihe));
      for x:=0 to 319 do tableground2^[x,y]:=reihe[x];
    end;

  for y:=400 to 599 do begin
      blockread(f,reihe,sizeof(reihe));
      for x:=0 to 319 do tableground3^[x,y]:=reihe[x];
    end;
  close(f);

end;

procedure load_arm_links;
var f:file;
    x,y:integer;
begin
  assign(f,'gfx\arml1.gfx');
  reset(f,1);
  blockread(f,arm_links^,ArmBreiteLinks*ArmHoeheLinks*5);
  close(f);

  if tnr='1' then begin
    for x := 1 to 15360 do
      case arm_links^[x] of
      $00 : arm_links^[x] := 234{30};
      $05 : arm_links^[x] := 31;
      $13 : arm_links^[x] := 32;
      $FF : arm_links^[x] := 33;
    end;
  end;
  if tnr='2' then begin
    for x := 1 to 15360 do
      case arm_links^[x] of
      $00 : arm_links^[x] := 00;
      $05 : arm_links^[x] := 00;
      $13 : arm_links^[x] := 12;
      $FF : arm_links^[x] := 11;
    end;
  end;
end;

procedure load_arm_rechts;
var f:file;
    x,y:integer;
begin
  assign(f,'gfx\armr1.gfx');
  reset(f,1);
  blockread(f,arm_rechts^,ArmBreiteRechts*ArmHoeheRechts*5);
  close(f);

  if tnr='1' then begin
    for x := 1 to 15360 do
      case arm_rechts^[x] of
      $00 : arm_rechts^[x] := 234{30};
      $05 : arm_rechts^[x] := 31;
      $13 : arm_rechts^[x] := 32;
      $FF : arm_rechts^[x] := 33;
    end;
  end;
  if tnr='2' then begin
    for x := 1 to 15360 do
      case arm_rechts^[x] of
      $00 : arm_rechts^[x] := 00;
      $05 : arm_rechts^[x] := 00;
      $13 : arm_rechts^[x] := 12;
      $FF : arm_rechts^[x] := 11;
    end;
  end;
end;


procedure load_arm_links_msk;
var f:file;
    x,y:integer;
begin
  assign(f,'msk\arml1.msk');
  reset(f,1);
  blockread(f,arm_links_msk^,ArmBreiteLinks*ArmHoeheLinks*5);
  close(f);
end;

procedure load_arm_rechts_msk;
var f:file;
    x,y:integer;
begin
  assign(f,'msk\armr1.msk');
  reset(f,1);
  blockread(f,arm_rechts_msk^,ArmBreiteRechts*ArmHoeheRechts*5);
  close(f);
end;


procedure load_ball;
var f:file;
    x,y:integer;
begin
  assign(f,'gfx\ball'+tnr+'.gfx');
  reset(f,1);
  blockread(f,ball^,256);
  close(f);
end;

procedure load_feder;
var f:file;
begin
  assign(f,'gfx\feder'+tnr+'.gfx');
  reset(f,1);
  blockread(f,feder^,filesize(f));
  close(f);
end;

procedure load_mini_palette(fname:string);
var palfile:file of byte;
    j:integer;
    mfm:word;
    colnr:byte;
begin
  mfm:=filemode;
  filemode:=0;
  if Pos('.',fname)=0 then fname:=fname+'.mpa';
  assign(palfile,fname);
  {$I-}
  reset(palfile);
  {$I+}
  if IOresult<>0 then sound(1000);
  repeat
    if not eof(palfile) then read(palfile,colnr);
    if not eof(palfile) then read(palfile,pal[colnr].r);
    if not eof(palfile) then read(palfile,pal[colnr].g);
    if not eof(palfile) then read(palfile,pal[colnr].b);
    set_rgb_color(colnr,pal[colnr].r,pal[colnr].g,pal[colnr].b);
  until eof(palfile);
  close(palfile);
  filemode:=mfm;
end;

{---------------------------------------------------------------------------}
