;ISR9.ASM --- Skeleton TSR, hooks IVT-9...
;assemble and link like a normal .EXE program.
.286
.MODEL SMALL
.STACK
.DATA
psp_size = 10h        ;in paragraphs (100h/16)

;..................................................
.CODE
start:  
	jmp 	installhooks          ;go to install portion

    oldoffivt9  DW      0
    oldsegivt9  Dw      0
    oldoffivt28 DW      0
    oldsegivt28 DW      0
    bypass      DB      0      ;fix reentrancy problems.
    killkeyboard DB     1      ;=1 disable keyboard.

;....................................................
runtime9:                      ;resident ISR.
	push    es              ;save all registers.
	push    ds              ;   /
	pusha                   ;   /

	pushf
	call    DWORD PTR cs:oldoffivt9 	;call old vector

	mov     ax,40h        ;keybuffer in BIOS data-area.
	mov     es,ax
	mov     bx,1Ah
        mov     ax,es:[bx+2]    ;get tail pointer
        mov     cx,es:[bx]      ;get head pointer

        cmp     ax,cx
        je      getout          ;buffer is empty
        mov     si,cx
        mov     dx,es:[si]      ;get ascii/scancode out of buffer.
        cmp     dx,2C00h        ;test for <ALT-Z> hotkey.
        jne     nothot          ;not the hotkey.
        xor     cs:killkeyboard,1       ;toggle keyboard enable/disable.

killit:
	mov     es:[bx],ax    ;clr key buffer
        jmp     SHORT getout

nothot:
        cmp     cs:killkeyboard,1
        je      killit

getout:
	popa
	pop     ds
	pop     es
	iret

;......................................................
    DB      17      DUP(0)
dumpme:
;......................................................
installhooks:
	push    cs
	pop     ds  ;note cs: overrides thus not really reqd.

;hook int-9....
	mov     ax,3509h                ;get old vector.
	int     21h                     ;IVT-->es:bx
	mov     oldoffivt9,bx
	mov     oldsegivt9,es
	mov     ax,2509h                ;set vector.
	lea     dx,runtime9             ;ds:dx-->IVT
	int     21h

;terminate, leave resident....
	lea     dx,dumpme       ;point past all resident code.
	shr     dx,4            ;compute # paragraphs to keep.
	add     dx,psp_size     ;       /
	mov     ax,3100h        ;terminate and stay resident.
	int     21h             ;       /

;......................................................
	END     start

Note that it is not necessary to use CLI to disable hardware interrupts
at the beginning of RUNTIME9:, as ISRs are always entered with the IF
clear.
Nor will we put STI inside RUNTIME9:, to allows hardware interrupts,
as that creates an interrupt nesting problem... potentially.
