;SLAVE.ASM                                      B.Kauler
;for use with MASTREXE.ASM, to demonstrate linking.
;LINK MASTREXE.OBJ+ SLAVE.OBJ+ SERF.OBJ --> MASTREXE.EXE
;SLAVE contains a procedure used by MASTER.
;A few points to note --
;None of the usual preliminary directives, nor a stack segment,
;as this module is only data & code that will be combined with
;the main program.
;Note that the data segment is labeled "data" and the code segment
;is labeled "code" -- same as in the master module.  This ensures that
;LINK will combine them into one code segment and one data segment.
;'data' and 'code' mean something different -- they just clarify to the
;LINKer which segments are code or data.
;Note that Microsoft & Intel have recently tended to favour labeling
;data segments with "_DATA" and code segments with "_TEXT",
;so that there is some standardisation of naming for linkage purposes.
;..........................................................
        public  slave_routine
;.........................................................
data    segment byte    public  'data'
        assume  ds:data   ;only used by Assembler to assemble data
                          ;references correctly. Doesn't actually
                          ;change DS.
local_mess db  "this data is in SLAVE module",0Ah,0Dh,"$"
data    ends
;.........................................................
code    segment byte    public  'code'
        assume  cs:code
;.............................
slave_routine   proc    near
        mov     dx,offset local_mess
        mov     ah,9
        int     21h       ;display message.
        ret
slave_routine   endp
;.......................................................
code    ends
        end               ;no label needed here.
