;PCX2SCRN.COM
;invoke by--  PCX2SCRN <enter>
;version 20/3 has filespec DEMO.PCX inside this program.
;displays the pcx file on an ega or vga (mode-16) screen.
;
comseg segment
 org 100h
 assume DS:comseg, CS:comseg
main proc far
 	jmp 	start

handle		dw	 2		;file handle.
screenaddr	dw	0,0A000h	;starting addr video-RAM, current line.
screenend		dw	350*80,0A000h	;ending addr video-RAM.
header		db 	128 dup(0)	;pcx header read into here.
buffer		db	200 dup(0)	;pcx file read into here.
bufferptr		dw	0			;pointer into buffer.
cnt16		dw	0		;palette register
cnt3			dw	0
cnt			dw	0
colour		dw	0
bitplane		dw	0
count		dw	0
content		dw	0
lineoffset	dw	0		;offset in video-RAM, current line.
filespec  	db	"temp.pcx",0	;*****temporarily added.

MSG1		DB	"Cannot open PCX file $"    ;****$ inserted
MSG2		DB	"Cannot read header $" 
closemsg	db	"Cannot close PCX file $"

colourmasks	DW	00H
	DW	08H
	DW	01H
	DW	09H

start:
	mov ah,3Dh		;open the file.
	mov dx,offset filespec
	mov al,0
	int 21h
	jc  openerror
	mov handle,ax		;handle 
	jmp short noerror
openerror:
	mov dx,offset MSG1
	mov ah,9
	int 21h
	jmp exitprog
noerror:

;***read & check the header...
 mov bx,handle		;filehandle
 mov cx,128
 mov dx,offset header
 mov ah,3Fh
 int 21h			;read file
 jc  readerror
	cmp	BYTE PTR header,10
	je	place1

readerror:
 mov dx,offset MSG2
 mov ah,9
 int 21h
 jmp exitprog

place1:
;******should put checking if mode 16 supported.
 mov ah,0
 mov al,16
 int 10h		;mode 16
	mov	WORD PTR cnt16,0
	jmp	SHORT place4

place2:					;set ega palette....
	mov	si,WORD PTR cnt16
	mov	ax,si
	shl	si,1
	add	si,ax
	mov	bx,WORD PTR cnt3
	mov	al,BYTE PTR header[bx+16][si]
	mov	cl,6
	sar	al,cl
	and	ax,3
	mov	si,ax
	mov	WORD PTR cnt,si
	shl	si,1
	mov	ax,WORD PTR colourmasks[si]
	mov	cl,2
	sub	cl,bl
	shl	ax,cl
	or	WORD PTR colour,ax
	inc	WORD PTR cnt3
place3:
	cmp	WORD PTR cnt3,3
	jl	place2

 mov ah,16		;set palette registers...
 mov al,0			;set individual palette register.
 mov bh,BYTE PTR colour	;value.
 mov	bl,BYTE PTR cnt16	;which register.
 int 10h

	inc	WORD PTR cnt16
place4:
	cmp	WORD PTR cnt16,16
	jge	place5		;to end of outer for-loop...

	sub	ax,ax
	mov	WORD PTR colour,ax
	mov	WORD PTR cnt3,ax
	jmp	SHORT place3
place5:			;end of outer loop.

;***select initial colour plane...
	mov	ax,2
	mov	dx,03C4h		;port 03C4h
	out	dx, al

	mov	ax,1
	mov	dx,03C5h		;port 03C5h
	out	dx, al

	mov	ax,0
	mov	WORD PTR screenaddr,ax
	mov	dx,0A000h		;top left byte of scrn mem
	mov	WORD PTR screenaddr+2,dx
	mov	ax,350*80
	mov	WORD PTR screenend,ax
	mov	dx,0A000h		;end of scrn.
	mov	WORD PTR screenend+2,dx
	sub	ax,ax
	mov	WORD PTR lineoffset,ax
	mov	WORD PTR content,ax
	mov	WORD PTR count,ax
	mov	WORD PTR bitplane,1
	mov	WORD PTR bufferptr,200

;***graphics data loop...
place6:
	mov	ax,WORD PTR screenaddr
	mov	dx,WORD PTR screenaddr+2
	cmp	WORD PTR screenend,ax
	jne	place7
	cmp	WORD PTR screenend+2,dx
	jne	place7
	jmp	place15

place7:			;start of the large not-end-mem loop
	cmp	WORD PTR bufferptr,200
	jne	place8
	mov	WORD PTR bufferptr,0

 mov bx, handle
 mov cx,200
 mov dx,offset buffer
 mov ah,3Fh
 int 21h					;read file

place8:			;***loop counter or data byte?
	mov	bx,WORD PTR bufferptr
	mov	al,BYTE PTR buffer[bx]
	cbw	
	mov	WORD PTR count,ax
	inc	WORD PTR bufferptr
	mov	al,BYTE PTR count
	and	ax,192
	cmp	ax,192
	jne	place10

	cmp	WORD PTR bufferptr,200	;third inner IF....
	jne	place9
	mov	WORD PTR bufferptr,0
 mov bx, handle		;file read...
 mov cx,200
 mov dx,offset buffer
 mov ah,3Fh
 int 21h					;read file

place9:					;
	mov	bx,WORD PTR bufferptr
	mov	al,BYTE PTR buffer[bx]
	cbw	
	mov	WORD PTR content,ax
	inc	WORD PTR bufferptr
	and	WORD PTR count,63
	jmp	SHORT place11		;jump around the else-condition...
	nop	

place10:
	mov	ax,WORD PTR count
	mov	WORD PTR content,ax
	mov	WORD PTR count,1

place11:
	mov	ax,WORD PTR count
	dec	WORD PTR count
	or	ax,ax
	jne	place12
	jmp	place6
place12:
	mov	al,BYTE PTR content
	les	bx,DWORD PTR screenaddr
	mov	si,WORD PTR lineoffset
	mov	BYTE PTR es:[bx][si],al

	inc	WORD PTR lineoffset
	cmp	WORD PTR lineoffset,80
	jne	place11
	mov	WORD PTR lineoffset,0

	cmp	WORD PTR bitplane,8
	jne	place13
	add	WORD PTR screenaddr,80
	mov	WORD PTR bitplane,1
	jmp	SHORT place14
	nop	
place13:				;***else condition...
	shl	WORD PTR bitplane,1
place14:
	mov	ax,WORD PTR bitplane
	mov	dx,03C5h		;port 03C5h
	out	dx, al

	jmp	SHORT place11	;three loops close here.
	nop	

place15:				;***finished
 mov bx, handle
 mov ah,3Eh
 int 21h				;close file
 jnc  nocloseerror
 mov dx,offset closemsg
 mov ah,9
 int 21h
 jmp short exitprog
nocloseerror:
 mov ah,2				;beep and wait for keypress....
 mov dl,07
 int 21h
 mov ah,0
 int 16h

 mov ah,0
 mov al,3
 int 10h					;back to text mode 3

exitprog:
 mov ax,4C00h
 int 21h		;exit
main	ENDP
comseg ends
 END main
