;OVLPARNT.COM                       B.Kauler
;This program demonstrates overlays.
;The parent and child are both .COM files in this case.
;The child is named DEMO.OVL.
;
comseg segment
        assume ds:comseg, cs:comseg, ss:comseg, es:comseg
        org 100h
main1   proc    far
        jmp     code_starts
;...................................................................
;data...
child_filespec db "demo.ovl",0  ;put path if reqd.
child_offset   dw   0   ;address of start of child program.
child_segment  dw   0,0,0,0,0,0,0,0   ;       /
errflag        db   0
message1       db "start of parent process",0Ah,0Dh,"$"
message2       db "back in parent process....$"
errmsg         db "A memory deallocation or file access ERROR occurred$"
;...................................................................
code_starts:
;the parent program doesn't do anything, except display a
;message, load the child, transfer control to it, then
;another message upon return, then back to DOS...
        mov     dx,offset message1
        mov     ah,9
        int     21h
;The stack pointer is way out at the end of the 64K segment, so move it in...
        mov bx,offset end_prog+126
        mov sp,bx
;...since the overlay is to load after it....
;END_PROG is a label defined at the very end of the parent
;program.  ES must point to start of PSP.
;The extra 128 bytes is for the stack-- .COM format automatically
;puts SP at the end of the segment, and we are here defining
;only as much as we think we'll need, and deallocating the
;rest of the segment.
;Function4Ah will define free memory to start from END_PROG+128...
        mov     bx,offset end_prog+144 ;use 144 so will be 1 para beyond SP.
        mov     cl,4            ;convert block-size to paragraphs.
        shr     bx,cl           ;       /
        mov     ah,4Ah          ;SET_BLOCK. (ES:BX(para)-->)
        int     21h             ;       /
        jnc     nodeallocerr
        mov     errflag,1
        jmp     short errcond
nodeallocerr:
;Some shuffling, to calculate the start of the new block...
        mov     ax,es           ;note ES points to start of PSP.
        add     ax,bx
        inc     ax              ;to be sure new block beyond current program.
        mov     child_offset,0
        mov     child_segment,ax
;now the really interesting bit....
        call    load_ovl        ;load DEMO.OVL
;DEMO.OVL is now loaded, with CHILD_ADDRESS containing
;the starting address of the child program....
;however before we can jump to it, think about DS...
;probably the child will want to access its own data area, so...
        mov     ax,child_segment
        mov     ds,ax
;another thought... if the child is written with a RETF at the end,
;we can go to it using a far CALL, which simplifies the return...
        call    dword ptr cs:child_offset
;that's it, back in the parent program....
;restore original DS (=CS in .COM program)....
        push    cs
        pop     ds
;a message to acknowledge the fact.....
        mov     dx,offset message2
        mov     ah,9
        int     21h
;do we need to close the child-file? better do it...
        call unloadovl
        cmp     errflag,0
        je      backtodos
        jmp     short backtodos
errcond: mov    dx,offset errmsg
        mov     ah,9
        int     21h
        mov     errflag,1   ;flag not used in this simple prog.
backtodos:
        mov     al,0
        mov     ah,4Ch
        int     21h
main1   endp
;..............................................................
load_ovl  proc near
;now we can load the child program....
        mov     bx,offset child_segment
        mov     dx,offset child_filespec
        mov     al,3            ;method code.
        mov     ah,4Bh
        int     21h             ;EXEC
        jnc     short commonexit
error2: mov     errflag,2
commonexit:
        ret
load_ovl endp
;.........
unloadovl proc near
;wise to deallocate the memory that the overlay was occupying...
        mov     es,child_segment
        mov     ah,49h
        int     21h
        jnc     deallocokay
        mov     errflag,3
deallocokay: nop
        ret
unloadovl endp
;.........
end_prog:
comseg  ends
 end     main1

