//simple C++ demo.
//OOP.CPP   demo OOP program, links C++ to .ASM member-function.
//to compile this file, called OOP.CPP, using Borland C++:
//  BCC OOP.CPP MEMBER.ASM
//or can do it in steps....
// BCC -c OOP.CPP
// TASM /ml MEMBER
// TLINK OOP MEMBER
//*****note that this .CPP file first had to be compiled to produce .ASM
//     output... see end of file.******

//.......................................................................
class box				//declaring a class called box.
{
	int row;			//giving it some data.
	int col;
public:
	virtual void place(int ,int);	//declaring a method called place().
};

class circle				//declaring a class called circle.
{      	int row,col;			//giving it some data.
public:
	virtual void place(int,int);	//declaring a method called place()
	virtual void draw();		//another method called draw()
};

//..........................................................................
void box::place(int r,int c)	//definition of place() belonging to box.
{
//	row = r;		//these two lines can also be done in
//	col = c;		//asm, as below....
	asm {
	mov si,this		//"this" equates to [bp+4]
	mov [si].row,r		//in-line assembly, can use all labels
	mov [si].col,c 		//from the C++ program.
				//"this" is the addr of current object.
	    }
}

void circle::draw(void)		//definition of draw() belonging to circle.
{				//does nothing.
}
//.........................................................................
	box box1;		//instances.  By declaring them here I am
	box box2;		//making them static, and they will be
	circle circle1;		//created in the data segment.
				//if i had declared them within main() they
				//would be automatic -- created on the
				//stack only (see below)...

//.......................................................................
main()
{
  box box3;			//instance created in stack segment.

  box1.place(3,5);		//calls place() belonging to box class,
				//with "this" set to box1.

  box *ptr;			//same thing using a pointer.
  ptr = &box1;			//required if we want this line to call
  ptr -> place(3,5);		//various place()'s depending on entry point.

  circle1.place(1,2);		//call the .asm function.
}

//........................................................................
//the following is anly a stub, to get the skeleton for a .asm module.
//Compile to produce .asm output, then remove this stub....
//See MEMBER.ASM for notes on this.

void circle::place(int r,int c)	//definition of place() belonging to circle.
//let's say that i want this function to be written in asm, not inline.
//furthermore, the asm program must have access to other C++ functions,
//and the data-members of its current instance....
//Firstly, bit of a skeleton at the C++ level....
{
	row=r; col=c;		//getting at current object's data.
	box1.place(1,2);	//calling another function, another object.
	this->draw();	  	//calling a function,same object.
}

// unfortunately i was unable to access row and col by name from MEMBER.ASM.
// ... this would have been nice.  However by specifying them in the above
// stub, you will find the appropriate code generated in the .ASM file.
// (My .ASM module is able to access C++ member-functions by their
// "mangled" names, so why not data-members by name?)