;INT8.COM      B.Kauler
;This program demonstrates "multitasking" by using a resident
;program and the timer-interrupt.
;A resident program opens many possibilities, and can be made to
;execute at the "same" time as another program.
;This is achieved by using int08 to call the resident program.
;Int08 is generated every 55mSec, and updates the BIOS clock.
;Our INSTALL routine can change the interrupt-8 vector in the
;interrupt table, to divert to the RUN_TIME routine, which would
;in turn transfer control back to the proper BIOS routine after
;doing whatever it wants.
;However, IBM considered that programmers would want to access the
;55mSec timer, so provided int1Ch "USER_TIMER_INT", which is
;called by int08 routine after it has done its own housekeeping.
;Normally int1Ch consists of simply an IRET instruction, but we
;can divert it to our own routine, which would terminate with an
;IRET.
;Note that our RUN_TIME routine could do many other things; maybe
;display the date or time on the screen continuously if we wished,
;rather than a message, in which case our routine would have to
;access int21h, functions 2Ah and 2Ch.
;The program INT9.COM accessed the interrupt table, but due to
;the danger of an interrupt occurring while writing to it (which
;we got around by a CLI), IBM provided INT21h functions 35h and
;25h to do the job.  This program uses these.
;
com_seg segment
        assume  cs:com_seg,ds:com_seg,ss:com_seg
        org     100h
int8    proc    far
        jmp     install
;
;data area....
int_offset      dw      0       ;original int1Ch vector.
int_seg         dw      0       ;       /
column          db      0       ;original cursor position.
row             db      0       ;       /
message         db      "MULTITASKING RESIDENT PROGRAM"
;
run_time:       ;displays message on screen.
;note; routine must be kept very short, as it is recalled every 55mSec.
;best to drive video ram directly.
        push    si
        push    di
        push    cx
        push    ax
        push    es
        push    ds
        push    cs
        pop     ds
        mov     ax,0b000h        ;video ram segment.
;****change this to 0B800h for colour adaptor*****
        mov     es,ax           ;       /
        mov     si,offset message
        mov     di,0            ;video offset.
        mov     ah,0f0h         ;attribute.
        mov     cx,001dh        ;loop count.
next_char: lodsb                   ;display a char.
        stosw                   ;       /
loop    next_char
        pop     ds
        pop     es
        pop     ax
        pop     cx
        pop     di
        pop     si
        iret
;
install:
        mov     al,1Ch  ;get interrupt vector.
        mov     ah,35h  ;       /
        int     21h     ;       / (--> ES:BX).
        mov     int_offset,bx   ;save vector.
        mov     int_seg,es      ;       /
;note that I have saved the original vector, to show how it is
;done, though in this program there's no need to.
        mov     dx,offset run_time      ;load new vector.
        ;COM file, so DS already set okay.
        mov     al,1Ch                  ;       /
        mov     ah,25h                  ;       /
        int     21h                     ;       / (DS:DX-->).
        mov     dx,offset install       ;point free memory,
        int     27h                     ;leave resident.
;
int8    endp
com_seg ends
end     int8

