;DSKSCRNB.COM           B.Kauler 1989.
;reads a text file from disk and displays it on the screen.
;DOS command line:  DSKSCRNB <filename >CON
;This method uses standard input and standard output, with
;redirection specified on the DOS command-line tail.
;Input is redirected from the keyboard to a file, and output
;need not be redirected since standard output is the screen.
;...therefore >CON is optional.... you could as an exercise
;try >PRN for output redirection.
;................................................................
comseg  segment
        assume  cs:comseg,ds:comseg,ss:comseg
        org     100h
main    proc    far
        jmp     code_starts
;................................................................
;data here.....
char_pos   db   0               ;character position on the line.
;................................................................
code_starts:
;read a character....
;note that we test for input status, as a file does not necessarily
;end with CTRL-Z.  This function sees if there is another character
;to be read, and if not returns AL=0.
again:  mov     ah,0Bh          ;INPUT_STATUS.
        int     21h             ;       /
        cmp     al,0
        je      eof
;The standard input device is specified on the DOS command line...
        mov     ah,7            ;STANDARD_INPUT
        int     21h             ;       / (-->AL).
;process the character....
        cmp     al,1Ah          ;is it CTRL-Z?
        je      eof
        cmp     al,09h          ;is it TAB?
        je      tab
        call    disp_char       ;display the char.
        inc     char_pos        ;update current char position.
        cmp     al,0Ah          ;test if end of line.
        jne     again           ;not end of line--get next char.
        mov     char_pos,0      ;clear char count.
        jmp     again           ;get next char.
;..................................................................
tab:    mov     al," "
        call    disp_char       ;display a blank.
        inc     char_pos        ;update current char position.
        test    char_pos,7      ;are we at a TAB stop?
        jz      again           ;yes.
        jmp     tab
;.................................................................
eof:    mov     al,0            ;return to DOS.
        mov     ah,4Ch          ;       /
        int     21h             ;       /
main    endp
;.................................................................
disp_char       proc    near
;send character to the standard output device....
        mov     ah,2            ;STANDARD_OUTPUT.
        mov     dl,al           ;       /
        int     21h             ;       /
        ret
disp_char endp
;................................................................
comseg  ends
end     main
