;DSKSCRNC.COM           B.Kauler 1989.
;reads a text file from disk and displays it on the screen.
;DOS command line:  DSKSCRNC [drive][path]filename
;Uses modern handles method.  Allows path to precede filename.
;................................................................
comseg  segment
        assume  cs:comseg,ds:comseg,ss:comseg
        org     100h
main    proc    far
        jmp     code_starts
;................................................................
;data here.....
handle     dw   0               ;identifies file.
dta        db   0               ;Disk Transfer Area.
char_pos   db   0               ;character position on the line.
filespec   db   32 dup (0)      ;DOS command-tail goes here.
errmsg     db   "file access error!!!!$"
;................................................................
code_starts:
;first job is to get the command-tail into FILESPEC...
        call    get_filespec
;open the file....
        mov     dx,offset filespec
        mov     al,0
        mov     ah,3Dh
        int     21h
        jc      error           ;carry-flag set if error.
        mov  handle,ax
;read a character....
again:  mov     bx,handle
        mov     cx,1            ;just read one character.
        mov     dx,offset dta   ;destination is DTA.
        mov     ah,3Fh          ;READ_HANDLE.
        int     21h             ;       /
        jc      error           ;carry-flag set if error.
        cmp     ax,0
        je      eof             ;end of file if AX=0.
        ;note that the file-pointer is updated by function3Fh.
;process the character....
        mov     al,dta          ;put the char in AL.
        cmp     al,1Ah          ;is it CTRL-Z?
        je      eof
        cmp     al,09h          ;is it TAB?
        je      tab
        call    disp_char       ;display the char.
        inc     char_pos        ;update current char position.
        cmp     al,0Ah          ;test if end of line.
        jne     again           ;not end of line--get next char.
        mov     char_pos,0      ;clear char count.
        jmp     again           ;get next char.
;..................................................................
tab:    mov     al," "          ;assume tab-stops every 8th column.
        call    disp_char       ;display a blank.
        inc     char_pos        ;update current char position.
        test    char_pos,7      ;are we at a TAB stop?
        jz      again           ;yes.
        jmp     tab
;.................................................................
eof:    mov     ah,3Eh          ;CLOSE_HANDLE.
        int     21h             ;       /
        jc      error
        mov     al,0            ;return to DOS.
        mov     ah,4Ch          ;       /
        int     21h             ;       /
;.................................................................
error:  mov     dx,offset errmsg ;display error message.
        mov     ah,9             ;      /
        int     21h              ;      /
        mov     al,0             ;could return an error code.
        mov     ah,4Ch
        int     21h              ;back to DOS
main    endp
;.................................................................
get_filespec    proc    near
        cld
        mov     si,082h         ;point to command-tail in PSP.
        mov     di,offset filespec ;point to destination.
read_next: lodsb
        cmp     al,0Dh          ;is char a carriage-return.
        je      end_string
        stosb
        jmp     read_next
end_string: ret
get_filespec endp
;.................................................................
disp_char       proc    near
;By default the standard output is the screen....
        mov     ah,2            ;STANDARD_OUTPUT.
        mov     dl,al           ;       /
        int     21h             ;       /
        ret
disp_char endp
;................................................................
comseg  ends
end     main

