;DSK2SCRN.COM           B.Kauler 1989.
;reads a text file from disk and displays it on the screen.
;DOS command line:  DSK2SCRN [filename]
;................................................................
comseg  segment
        assume  cs:comseg,ds:comseg,ss:comseg
        org     100h
main    proc    far
        jmp     code_starts
;................................................................
;disk access data here.....
fcb     db      36 dup(0)       ;file control block.
dta     db      0               ;disk transfer area(1byte only).
err_msg db      "file access error!"
;
;program data here.....
char_pos   db   0               ;character position on the line.
;................................................................
code_starts:
;read the DOS-command-line tail from the PSP, to a File Control
;Block (FCB) that we are creating for the file to be opened.....
        mov     si,5Ch          ;get addr of tail in PSP.
        mov     di,offset fcb   ;get addr of FCB.
        mov     cx,12           ;string length to move.
        cld
        rep movsb               ;mov string PSP -->FCB.
;We need to specify a Disk Transfer Address, through which chars
;are sent to and received from disk....
        mov     dx,offset dta   ;DOS function SET_DTA.
        mov     ah,1Ah          ;       /(DS:DX-->)
        int     21h             ;       /
;the filename must be at DS:DX to open the file.  We have the name
;in the FCB, so....
        mov     dx,offset fcb   ;DOS function OPEN_FILE.
        mov     ah,0Fh          ;       /(DS:DX-->)
        int     21h             ;       /
        cmp     al,0            ;test file open error.
        jnz     error
;If function 0Fh succeeds in opening the file, various relevant
;information is automatically transfered from disk into the FCB.
;the first byte of the FCB will hold the disk number from which
;the file was read, and offset 0Eh specifies the record-size
;and is set to 128, which is arbitrary, and we can change it and
;other parameters....
        mov     word ptr fcb+0Ch,0      ;current block=0.
        mov     word ptr fcb+0Eh,1      ;record size=1
        mov     fcb+20h,0               ;current record=0
;read a char from file & display it....
;note that we test here for CTRL-Z to determine the end of the
;file, as CTRL-Z occurs at the end of text files, however
;function 14h returns an error-code in AL that can be used to
;signal the end of file.
again:  mov     dx,offset fcb   ;DOS function SEQUENTIAL_READ.
        mov     ah,14h          ;       /
        int     21h             ;       /
        cmp     al,0            ;test if read error.
        jnz     error
        mov     al,dta          ;get the char just read.
        cmp     al,1Ah          ;is it CTRL-Z?
        je      eof
        cmp     al,09h          ;is it TAB?
        je      tab
        call    disp_char       ;display the char.
        inc     char_pos        ;update current char position.
        cmp     dta,0Ah         ;test if end of line.
        jne     again           ;not end of line--get next char.
        mov     char_pos,0      ;clear char count.
        jmp     again           ;get next char.
;..................................................................
tab:    mov     al," "
        call    disp_char       ;display a blank.
        inc     char_pos        ;update current char position.
        test    char_pos,7      ;are we at a TAB stop?
        jz      again           ;yes.
        jmp     tab
;.................................................................
eof:    mov     dx,offset fcb   ;DOS function CLOSE_FILE.
        mov     ah,10h          ;       /
        int     21h             ;       /
        mov     al,0            ;return to DOS.
        mov     ah,4Ch          ;       /
        int     21h             ;       /
;.................................................................
error:  mov     dx,offset err_msg       ;display error message.
        mov     ah,9                    ;       /
        int     21h                     ;       /
        mov     al,0            ;return to DOS.
        mov     ah,4Ch          ;       /
        int     21h             ;       /
;.................................................................
disp_char       proc    near
        push    bx
        mov     bx,0            ;display a char.
        mov     ah,14           ;       /
        int     10h             ;       /
        pop     bx
        ret
;................................................................
main    endp
comseg  ends
end     main
