
    ;DRIVER1.SYS           B.Kauler
    ;simple device driver
    ;.....
    code_seg  segment para    public  'code'
    main_proc proc    far
      assume  cs:code_seg,es:code_seg,ds:code_seg
      org 0   ;required for device drivers.
    begin:
    ;...........................................
    ;this area is the DEVICE HEADER....
    next_dev   dd -1      ;no other device drivers
    attribute  dw 8000h   ;character device.
    strategy   dw dev_str ;addr of 1st DOS call.
    interrupt  dw dev_int ;addr of 2nd DOS call.
    dev_name   db "driver1$" ;name of the driver.
    ;...........................................
    ;this is the LOCAL WORKSPACE AREA....
    rh_off   dw ?  ;Request Header offset.
    rh_seg   dw ?  ;Request Header segment.
    messages db 07h
             db "Simple character device driver"
             db 0Dh,0Ah,07h,"$"
    ;...........................................
    ;this is the STRATEGY procedure area...
    dev_str:
        push   ds         ;save DS.
        push   cs         ;to avoid segment
        pop    ds         ;         override.
        mov    rh_seg,es  ;save Req.Header seg.
        mov    rh_off,bx  ;save Req.Head offset.
        pop    ds         ;restore DS.
        ret
    ;..........................................
    ;this is the INTERRUPT procedure.....
    dev_int:
        push    ds      ;save registers.
        push    es      ;       /
        push    ax      ;       /
        push    bx      ;       /
        push    cx      ;       /
        push    dx      ;       /
        push    di      ;       /
        push    si      ;       /
        push   cs       ;to avoid segment
        pop    ds       ;    override.
    ;I will not assume that the second call to the
    ;driver will still have the addr. of the Req.
    ;Hdr. in ES:BX. Load it from workspace...
        mov     es,rh_seg
        mov     bx,rh_off
    ;perform branch based on the command passed in
    ;the Request Header...
        mov     al,es:[bx+2] ;get command code.
        cmp     al,0         ;check for zero.
        jne     errors
    ;perform required action...
        mov     dx,offset messages ;message
        mov     ah,9               ;to screen.
        int     21h                ;/
      mov es:word ptr [bx+3],0100h ;return status.
    ;it seems that DOS will also require to know
    ;where the driver ends....
        mov     ax,offset the_end ;end prog.
        mov es:[bx+14],ax ;break-addr for DOS.
        mov es:[bx+16],cs ;     /
        jmp finish
    errors:
      mov es:word ptr [bx+3],8103h ;return status
    finish:
        pop si           ;restore all reg's.
        pop di
        pop dx
        pop cx
        pop bx
        pop ax
        pop es
        pop ds
        ret
    the_end:
    ;..........................................
    main_proc    endp
    code_seg     ends
                 end    begin
    ;*****end of device driver******
    ;..........................................

