;C2ASM.ASM   B.Kauler 1990.
;the skeleton .ASM module below was created by compiling a skeleton C program
;of arbitrary name filename1.c, as follows;
;
; add(a,b)
; int a,b;
; { int x; x=a+b; return x; }
;
;compiled with the /Fa switch to generate .ASM output, and the /c switch to
;suppress linking --   CL /Fa /c filename1.C ,,,   (Microsoft C v6.0)
;
;Have a look at the listing below.  Note that a & b are defined as "int",
;which corresponds to MASM's "word", that is, 16 bits, so word-size values
;are passed on the stack to the .ASM routine.  By default the "add" function
;returns a word-size value via AX, to variable x.
;
;.................................
INCLUDELIB	SLIBCE
_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME DS: DGROUP, SS: DGROUP
EXTRN	__aNchkstk:NEAR
extrn _var1:word        ;added by me. see notes below.
;
_TEXT      SEGMENT
	ASSUME	CS: _TEXT
	PUBLIC	_add
_add	PROC NEAR
	push	bp
	mov	bp,sp
	mov	ax,2
	call	__aNchkstk        ;this is a compiler-supplied routine, to check that
                        ;the stack has enough room (no. bytes spec. by AX).
	mov	ax,WORD PTR [bp+6]	;b
	add	ax,WORD PTR [bp+4]	;a

 adc ax,_var1           ;added by me. see notes below.

	mov	sp,bp
	pop	bp
	ret	
	nop	
_add	ENDP
_TEXT	ENDS
END
;......................................
;
;this basic skeleton can be used for any .ASM routine.
;here is a C program that will call the above .ASM routine --
; #include <stdio.h>
; int var1=2;
; main()
; { int x,y=3,z=5; x=add(y,z); printf("answer = %hu",x); }
;
;it defines x,y and z as 16-bit, passes y and z on the stack to the .ASM
;routine, which returns a value to x via AX register.
;x,y and z are local variables, however I have also included a global
;variable, "var1" -- look back at the .ASM routine to see how it can
;access a C global variable.
;if this C program is called filename2.c, and the .ASM program is filename1,
;this is the process of compiling & linking with MS C v6.0 --
; MASM filename1;               ;filename1.asm --> filename1.obj
; CL /c filename2.c ,,,         ;filename2.c --> filename2.obj
; LINK filename2+ filename1;    ; --> filename2.EXE
;
;what if you want to pass values other than 16-bit?
;C's "long int" is the same as MASM's "doubleword", that is, 32 bits.
;here is a C skeleton that you can compile to .ASM for passing long int's;
; long int add(a,b)
; long int a,b;
; { long int x; x=a+b; return x; }
;
;as this must also return a long integer, Microsoft C does so in DX:AX.
;A master C program that can call such a .ASM module --
; #include <stdio.h>
; main()
; { long int x,y=3,z=5; x=add(y,z); printf("answer = %lu",x); }
;
;note that "%lu" is a format specifier for x, being "long unsigned integer".
;Actually, you may need to specifiy add() as being external, and for 
;certain memory models, such as small, you will need to provide an 
;override if you want the add() module to be far --
;  extern far long int add(long int, long int);
;..............................................................
