                                     (* Chapter 14 - Program 2 *)
program Encapsulation_2;

type
   Box = object
      constructor Init(len, wid : integer);
      procedure Set_Data(len, wid : integer);
      function Get_Area : integer;
   private       (* Remove this if you are using TURBO Pascal 5.5, *)
      length : integer;   (* and move both variables               *)
      width  : integer;   (*                ahead of the methods.  *)
   end;

   Pole = object
      constructor Init(hei, dep : integer);
      procedure Set_Data(hei, dep : integer);
      function Get_Total_Length : integer;
   private       (* Remove this if you are using TURBO Pascal 5.5, *)
      height : integer;   (* and move both variables               *)
      depth  : integer;   (*                ahead of the methods.  *)
   end;

   constructor Box.Init(len, wid : integer);
   begin
      length := len;
      width := wid;
   end;

   constructor Pole.Init(hei, dep : integer);
   begin
      height := hei;
      depth := dep;
   end;

   procedure Box.Set_Data(len, wid : integer);
   begin
      length := len;
      width := wid;
   end;

   function Box.Get_Area : integer;
   begin
      Get_Area := length * width;
   end;

   procedure Pole.Set_Data(hei, dep : integer);
   begin
      height := hei;
      depth := dep;
   end;

   function Pole.Get_Total_length : integer;
   begin
      Get_Total_length := height + depth;
   end;

var Small, Medium, Large : Box;
    Short, Average, Tall : Pole;

begin

   Small.Init(8,8);
   Medium.Init(10,12);
   Large.Init(15,20);
   Short.Init(8,2);
   Average.Init(12,3);
   Tall.Init(17,4);

   (* Small.length := 7; *)

   WriteLn('The area of the small box is ',Small.Get_Area);
   WriteLn('The area of the medium box is ',Medium.Get_Area);
   WriteLn('The area of the large box is ',Large.Get_Area);
   WriteLn('The overall length of the short pole is ',
                                          Short.Get_Total_Length);
   WriteLn('The overall length of the average pole is ',
                                        Average.Get_Total_Length);
   WriteLn('The overall length of the tall pole is ',
                                           Tall.Get_Total_Length);
   WriteLn;

   Small.Set_Data(6,7);
   Short.Set_Data(6,1);
   Average.Set_Data(11,2);
   WriteLn('The area of the small box is ',Small.Get_Area);
   WriteLn('The area of the medium box is ',Medium.Get_Area);
   WriteLn('The area of the large box is ',Large.Get_Area);
   WriteLn('The overall length of the short pole is ',
                                          Short.Get_Total_Length);
   WriteLn('The overall length of the average pole is ',
                                        Average.Get_Total_Length);
   WriteLn('The overall length of the tall pole is ',
                                           Tall.Get_Total_Length);

end.




{ Result of execution

The area of the small box is 64
The area of the medium box is 120
The area of the large box is 300
The overall length of the short pole is 10
The overall length of the average pole is 15
The overall length of the tall pole is 21

The area of the small box is 42
The area of the medium box is 120
The area of the large box is 300
The overall length of the short pole is 7
The overall length of the average pole is 13
The overall length of the tall pole is 21

}