// rotozoomer example.

#include <string.h>
#include <conio.h>
#include <math.h>
#include <stdlib.h>
#include "roto.h"
#include "timer.h"

void vidmode(short);
#pragma aux vidmode parm [ax] = "int 10h"

void main()
{
  unsigned char *mapptr=new unsigned char [0x20000];
  unsigned char *map=(unsigned char*)(((unsigned long)mapptr+0xFFFF)&~0xFFFF);
// map is segment aligned.

  int i,j;

  for (i=0; i<256; i++)   // simple xor pattern
    for (j=0; j<256; j++)
      map[i*256+j]=i^j;
  for (i=0; i<256; i++)   // thin vertical line
    map[i*256]=(i&1)?0:255;
  for (i=0; i<256; i++)   // thick horizontal line
    for (j=0; j<4; j++)
      map[i+j*256]=((i^j)&1)?0:255;
  for (i=0; i<16; i++)    // mark texture origin
    for (j=0; j<16; j++)
      map[i*256+j]=((i^j)&1)?0:255;

  vidmode(0x13);
  outp(0x3c8, 0);  // grey palette
  for (i=0; i<64; i++)
    for (j=0; j<12; j++)
      outp(0x3c9,i);

  tmInit();

  unsigned long starttime=tmGetTimer();
  int frame=0;
  while (!kbhit())
  {
    double frametime=tmGetTimer()*0.00005; // some values
    double xmid=160+sin(frametime*0.0067521345+0.1)*90;
    double ymid=100+sin(frametime*0.00912348976+0.5)*90;
    double txmid=128+sin(frametime*0.000913784+1.02434)*64;
    double tymid=128+sin(-frametime*0.0012821345+2.1944)*64;
    double zoom=exp(sin(frametime*0.00398175)*0.8-0.5);
    double angle=frametime*0.012345897;

    long zoomx=65536/1.2*zoom*cos(angle); // transformation matrix calculation
    long zoomy=65536/1.2*zoom*sin(angle);
    long zoomxd=-65536*zoom*sin(angle);
    long zoomyd=65536*zoom*cos(angle);
    long curx=txmid-xmid*zoomx-ymid*zoomxd;
    long cury=tymid-xmid*zoomy-ymid*zoomyd;

    while (inp(0x3da)&8);    // wait for retrace, comment to get
    while (!(inp(0x3da)&8)); // maximum framerate as a benchmark.
    outp(0x3c8,0); // show frametime needed
    outp(0x3c9,63);
    outp(0x3c9,0);
    outp(0x3c9,0);
    texturescreen((unsigned char*)0xA0000, map, curx, cury, zoomx, zoomy, zoomxd, zoomyd, 40, 25, 320, ROTO_MOV, abs(zoomx)<abs(zoomy));
    outp(0x3c8,0);
    outp(0x3c9,0);
    outp(0x3c9,0);
    outp(0x3c9,0);

    frame++;
  }

  unsigned long endtime=tmGetTimer();

  tmClose();

  while (kbhit()) // flush
    getch();
  vidmode(3);
  vidmode(3);

  char buf[30];
  ultoa(frame*11930460.0/(endtime-starttime), buf, 10);
  buf[strlen(buf)+1]=0;
  buf[strlen(buf)]=buf[strlen(buf)-1];
  buf[strlen(buf)-2]='.';
  strcat(buf, " fps\r\n");
  cputs(buf);
}
