program Amortization_Table;

var Month : 1..12;
    Starting_Month : 1..12;
    Balance : real;
    Payment : real;
    Interest_Rate : real;
    Annual_Accum_Interest : real;
    Year : integer;

procedure Initialize_Data; (* ******************** initialize data *)
begin
   Balance := 2500.0;
   Starting_Month := 5;
   Payment := 100.0;
   Interest_Rate := 0.13/12.0;
   Annual_Accum_Interest := 0.0; (* This is to accumulate Interest *)
   Year := 1985;
end;

procedure Print_Annual_Header; (* ************ print annual header *)
begin
   Writeln;
   Writeln('Month    payment  interest    princ   balance');
   Writeln;
end;

procedure Calculate_And_Print; (* ************ calculate and print *)
var Interest_Payment : real;
    Principal_Payment : real;
begin
   if Balance > 0.0 then begin
      Interest_Payment := Interest_Rate * Balance;
      Principal_Payment := Payment - Interest_Payment;
      if Principal_Payment > Balance then begin  (* loan payed off *)
         Principal_Payment := Balance;             (* this month *)
         Payment := Principal_Payment + Interest_Payment;
         Balance := 0.0;
      end
      else begin  (* regular monthly payment *)
         Balance := Balance - Principal_Payment;
      end;
      Annual_Accum_Interest := Annual_Accum_Interest+Interest_Payment;
      Writeln(Month:5,Payment:10:2,Interest_Payment:10:2,
              Principal_Payment:10:2,Balance:10:2);
   end; (* of if Balance > 0.0 then *)
end;

procedure Print_Annual_Summary; (* ********** print annual summary *)
begin
   Writeln;
   Writeln('Total interest for ',Year:5,' = ',
            Annual_Accum_Interest:10:2);
   Annual_Accum_Interest := 0.0;
   Year := Year + 1;
   Writeln;
end;

begin   (* ******************************************* main program *)
   Initialize_Data;
   repeat
      Print_Annual_Header;
      for Month := Starting_Month to 12 do begin
         Calculate_And_Print;
      end;
      Print_Annual_Summary;
      Starting_Month := 1;
   until Balance <= 0.0;
end.  (* of main program *)
