                                (* Chapter 12 - Program 4 *)
program A_Dynamic_Storage_Record;

const  Number_Of_Friends = 50;

type Full_Name = record
      First_Name : string[12];
      Initial    : char;
      Last_Name  : string[15];
      end;

     Date      = record
      Day        : byte;
      Month      : byte;
      Year       : integer;
      end;

     Person_Id = ^Person;
     Person    = record
      Name       : Full_Name;
      City       : string[15];
      State      : string[2];
      Zipcode    : string[5];
      Birthday   : Date;
      end;

var   Friend             : array[1..Number_Of_Friends] of Person_Id;
      Self,Mother,Father : Person_Id;
      Temp               : Person;
      Index              : byte;

begin  (* main program *)
   New(Self);   (* create the dynamic variable *)
   Self^.Name.First_Name := 'Charley';
   Self^.Name.Initial    := 'Z';
   Self^.Name.Last_Name  := 'Brown';
   with Self^ do begin
      City := 'Anywhere';
      State := 'CA';
      Zipcode := '97342';
      Birthday.Day := 17;
      with Birthday do begin
         Month := 7;
         Year := 1938;
      end;
   end;    (* all data for self now defined *)

   New(Mother);
   Mother := Self;
   New(Father);
   Father^ := Mother^;
   for Index := 1 to Number_Of_Friends do begin
      New(Friend[Index]);
      Friend[Index]^ := Mother^;
   end;

   Temp := Friend[27]^;
   Write(Temp.Name.First_Name,' ');
   Temp := Friend[33]^;
   Write(Temp.Name.Initial,' ');
   Temp := Father^;
   Write(Temp.Name.Last_Name);
   Writeln;

   Dispose(Self);
{  Dispose(Mother); } (* since Mother is lost, it cannot
                         be disposed of                  *)
   Dispose(Father);
   for Index := 1 to Number_Of_Friends do
      Dispose(Friend[Index]);
end. (* of main program *)