unit XMode;
{
  X-Modes (256 colors multipage) library v1.1
  -----------------------------------------------------------------------

   New features added in v1.1 (some of them based on routines by Themie Gouthas)
   
    xvplot    - virtual plot, with clipping the unnecessarry points
    xline     - fast line drawing routine
    xcircle   - fast circle drawing routine
    xdisc     - fast disc (filled circle) drawing routine
    xfillrect - filled rectangle
    xpattrect - pattern-filled rectangle
  --------------------------------------------------------------------------

  Original C++ shit by Kaos of Black Magic - thanks.
  Adapted version for Pascal, enhancements and new routines by Maple Leaf
}
interface

{ Drawing routines }
Procedure XFillRect(StartX, StartY, EndX, EndY:Integer; color, vpage:word);
Procedure XPattRect(StartX, StartY, EndX, EndY:Integer; pattern:pointer; vpage:word);
Procedure XCircle(x, y, radius:integer; color:word; vpage:word);
Procedure XDisc(x, y, radius:integer; color:word; vpage:word);
Procedure XLine(x1,y1,x2,y2:integer; color:word; vpage:word);
Procedure XPlot(x,y:integer; Color:Byte; VPage:Word);
Procedure XVPlot(x,y:integer; Color:Byte; VPage:Word);
Function  XGet(x,y, VPage:integer):Byte;
{ Init/done }
Procedure XInitVideo(Mode:Word);
Procedure XTextMode(mode:Byte);
{ Clear }
Procedure XClrVRam;
Procedure XClrVPage(VPage:Word);
{ Pages, windows }
Procedure XSetVPage(VPage:Word);
Procedure XResize(x,y:Word);
Procedure XPanScr(x,y:Word);
Procedure XSplit(n:Word);
Procedure MoveWin(Buffer1, Buffer2:pointer; VPage:Word);
Procedure XScreenOff;
Procedure XScreenOn;
{ Bitmaps }
Procedure XImagePut(BitMap:Pointer; x,y,VPage:Word);
Procedure XImageOrPut(BitMap:Pointer; x,y,VPage:Word);
Procedure XImageAdd(BitMap:Pointer; x,y,VPage:Word);
Procedure XImageOvr(BitMap:Pointer; x,y,VPage:Word);
{ Others }
Function  XLinePutCY(Ptr:Pointer; ya,x,y,VPage:Word):Word;
Procedure XBlock(x1,y1,count,y2:word; Color:Byte; VPage:Word);
{ Syncronization }
Procedure XVWait;
Procedure XHWait;
{ Borders }
Procedure XSetBorder(Color:Byte);
Procedure XSetBorder2(red,green,blue:byte);
{ Palette }
Procedure XSetPalette(PalPtr:Pointer);
Procedure XGetPalette(FirstReg, NumRegs:Word; Palette:Pointer);
Procedure XSetRGB(color,red,green,blue:byte);

implementation

{$L xmode.obj}

Procedure XFillRect;           external;
Procedure XPattRect;           external;
Procedure XCircle;             external;
Procedure XDisc;               external;
Procedure XLine;               external;
Procedure XInitVideo;          external;
Procedure XClrVRam;            external;
Procedure XClrVPage;           external;
Procedure XSetVPage;           external;
Procedure XPlot;               external;
Procedure XVPlot;              external;
Function  XGet;                external;
Procedure XImagePut;           external;
Procedure XImageOrPut;         external;
Procedure XImageAdd;           external;
Procedure XImageOvr;           external;
Procedure XResize;             external;
Procedure XPanScr;             external;
Procedure XSplit;              external;
Function  XLinePutCY;          external;
Procedure XBlock;              external;
Procedure XVWait;              external;
Procedure XHWait;              external;
Procedure XSetBorder;          external;
Procedure XSetBorder2;         external;
Procedure XScreenOff;          external;
Procedure XScreenOn;           external;
Procedure XSetPalette;         external;
Procedure XGetPalette;         external;
Procedure XSetRGB;             external;
Procedure XTextMode;           external;
Procedure MoveWin;             external;

begin
end.