COMMENT $
  ----- Engine 3D -----
  3D to 2D mapping routine, by Maple Leaf - 1996
$

.386c

DATA  segment  word public use16
      extrn    RotAngle:WORD
      extrn    TiltAngle:WORD
      extrn    Xt, Yt, Zt : DWORD
      extrn    _3DX, _3DY, _3DZ : DWORD
      extrn    _2DX, _2DY : DWORD
      extrn    CenterX, CenterY : DWORD
      extrn    SinTab:BYTE
      extrn    CosTab:BYTE
      extrn    ObserverX, ObserverY, ObserverDist : DWORD
      extrn    TmpEqu:DWORD
      extrn    Perspective:BYTE
      extrn    ZoomFactor:WORD
      extrn    CameraX, CameraY, CameraZ : DWORD
DATA  ends

CODE  segment  byte public use16
      assume   ds:DATA,cs:CODE

      public   IntMapCoordinates
      public   IntMapCoordinates2

;*****************************************************************************

IntMapCoordinates proc far
    mov     si,RotAngle
    mov     di,TiltAngle
    shl     si,1
    shl     si,1
    shl     di,1
    shl     di,1
    ; ----- _3dx:=_3dx-CameraX -----
    mov     eax,dword ptr _3DX
    sub     eax,dword ptr CameraX
    mov     dword ptr _3DX,eax
    ; ----- _3dy:=_3dy-CameraY -----
    mov     eax,dword ptr _3DY
    sub     eax,dword ptr CameraY
    mov     dword ptr _3DY,eax
    ; ----- _3dz:=_3dz-CameraZ -----
    mov     eax,dword ptr _3DZ
    sub     eax,dword ptr CameraZ
    mov     dword ptr _3DZ,eax
    ; ----- Xt:=ObserverX+_3DX*CosA-_3DY*SinA -----
    mov     eax,dword ptr _3DY
    mov     ecx,dword ptr SinTab[si]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DX
    mov     ecx,dword ptr CosTab[si]
    imul    ecx
    sub     eax,ebx
    mov     ebx,dword ptr ObserverX
    sal     ebx,8
    add     eax,ebx
    sar     eax,8
    mov     dword ptr Xt,eax
    ; -- Yt:= ObserverY + (_3DX*SinA + _3DY*CosA)*SinB + _3DZ*CosB; --
    mov     eax,dword ptr _3DX
    mov     ecx,dword ptr SinTab[si]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DY
    mov     ecx,dword ptr CosTab[si]
    imul    ecx
    add     eax,ebx
    sar     eax,8
    mov     dword ptr TmpEqu,eax
    mov     ecx,dword ptr SinTab[di]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DZ
    mov     ecx,dword ptr CosTab[di]
    imul    ecx
    add     eax,ebx
    mov     ebx,dword ptr ObserverY
    sal     ebx,8
    add     eax,ebx
    sar     eax,8
    mov     dword ptr Yt,eax
    ; --- if perspective then begin ---
    cmp     Perspective,1     ; Want perspective ? If yes, then another
    jne     @NoPerspective    ; 6 more IMUL instructions will appear ... (half speed) - I really don't know how to optimize this shit ...  ;=)  f#$%^&* !!!
    ; --- Zt:=ObserverDist+(_3DX*SinA+_3DY*CosA)*CosB-(_3DZ*SinB); ---
    mov     eax,dword ptr TmpEqu
    mov     ecx,dword ptr CosTab[di]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DZ        ;<--; This could be erased if ya want
    mov     ecx,dword ptr SinTab[di]  ;   ; more speed, but some parts of the
    imul    ecx                       ;   ; perspective will be lost ...
    sub     ebx,eax                   ;<--; (e.g. One running-point)
    mov     eax,dword ptr ObserverDist
    sal     eax,8
    add     eax,ebx
    sar     eax,8
    jnz     @@1
    mov     eax,1     ; To prevent division by 0 ...
@@1:mov     dword ptr Zt,eax
    ; ---- _2DX:=CenterX+Trunc(Xt*ZoomFactor/Zt); ----
    mov     eax,dword ptr Xt
    mov     ecx,dword ptr ZoomFactor
    imul    ecx
    mov     ecx,dword ptr Zt
    idiv    ecx
    add     eax,dword ptr CenterX
    mov     dword ptr _2DX,eax
    ; ---- _2DY:=CenterY-Trunc(Yt*ZoomFactor/Zt*13/16); ----
    mov     eax,dword ptr Yt
    mov     ecx,dword ptr ZoomFactor
    imul    ecx
    mov     ecx,dword ptr Zt
    idiv    ecx
    ;
    shl     eax,1        ; This part is the equivalent of:
    mov     ebx,eax      ; -----------
    shl     eax,1        ; mov ecx,13
    add     ebx,eax      ; imul ecx
    shl     eax,1        ; -----------
    add     eax,ebx      ;
    ;
    sar     eax,4
    mov     ebx,dword ptr CenterY
    sub     ebx,eax
    mov     dword ptr _2DY,ebx
    jmp     @Outta
@NoPerspective:
    ; ---- _2DX:=CenterX+Trunc(Xt); ----
    mov     eax,dword ptr Xt
    add     eax,dword ptr CenterX
    mov     dword ptr _2DX,eax
    ; ---- _2DY:=CenterY-Trunc(Yt*13/16); ----
    mov     eax,dword ptr Yt
    ;
    shl     eax,1        ; This part is the equivalent of:
    mov     ebx,eax      ; -----------
    shl     eax,1        ; mov ecx,13
    add     ebx,eax      ; imul ecx
    shl     eax,1        ; -----------
    add     eax,ebx      ;
    ;
    sar     eax,4
    mov     ebx,dword ptr CenterY
    sub     ebx,eax
    mov     dword ptr _2DY,ebx
@Outta:
    retf
IntMapCoordinates endp

;*****************************************************************************

IntMapCoordinates2 proc far
    mov     si,RotAngle
    mov     di,TiltAngle
    shl     si,1
    shl     si,1
    shl     di,1
    shl     di,1
    ; ----- _3dx:=_3dx-CameraX -----
    mov     eax,dword ptr _3DX
    sub     eax,dword ptr CameraX
    mov     dword ptr _3DX,eax
    ; ----- _3dy:=_3dy-CameraY -----
    mov     eax,dword ptr _3DY
    sub     eax,dword ptr CameraY
    mov     dword ptr _3DY,eax
    ; ----- _3dz:=_3dz-CameraZ -----
    mov     eax,dword ptr _3DZ
    sub     eax,dword ptr CameraZ
    mov     dword ptr _3DZ,eax
    ; ----- Xt:=ObserverX+_3DX*CosA-_3DY*SinA -----
    mov     eax,dword ptr _3DY
    mov     ecx,dword ptr SinTab[si]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DX
    mov     ecx,dword ptr CosTab[si]
    imul    ecx
    sub     eax,ebx
    mov     ebx,dword ptr ObserverX
    sal     ebx,8
    add     eax,ebx
    sar     eax,8
    mov     dword ptr Xt,eax
    ; -- Yt:= ObserverY + (_3DX*SinA + _3DY*CosA)*SinB + _3DZ*CosB; --
    mov     eax,dword ptr _3DX
    mov     ecx,dword ptr SinTab[si]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DY
    mov     ecx,dword ptr CosTab[si]
    imul    ecx
    add     eax,ebx
    sar     eax,8
    mov     dword ptr TmpEqu,eax
    mov     ecx,dword ptr SinTab[di]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DZ
    mov     ecx,dword ptr CosTab[di]
    imul    ecx
    add     eax,ebx
    mov     ebx,dword ptr ObserverY
    sal     ebx,8
    add     eax,ebx
    sar     eax,8
    mov     dword ptr Yt,eax
    ; --- if perspective then begin ---
    cmp     Perspective,1     ; Want perspective ? If yes, then another
    jne     @NoPerspective2   ; 6 more IMUL instructions will appear ... (half speed) - I really don't know how to optimize this shit ...  ;=)  f#$%^&* !!!
    ; --- Zt:=ObserverDist+(_3DX*SinA+_3DY*CosA)*CosB-(_3DZ*SinB); ---
    mov     eax,dword ptr TmpEqu
    mov     ecx,dword ptr CosTab[di]
    imul    ecx
    mov     ebx,eax
    mov     eax,dword ptr _3DZ        ;<--; This could be erased if ya want
    mov     ecx,dword ptr SinTab[di]  ;   ; more speed, but some parts of the
    imul    ecx                       ;   ; perspective will be lost ...
    sub     ebx,eax                   ;<--; (e.g. One running-point)
    mov     eax,dword ptr ObserverDist
    sal     eax,8
    add     eax,ebx
    sar     eax,8
    jnz     @@2
    mov     eax,1     ; To prevent division by 0 ...
@@2:mov     dword ptr Zt,eax
    ; ---- _2DX:=CenterX+Trunc(Xt*ZoomFactor/Zt); ----
    mov     eax,dword ptr Xt
;    mov     ecx,dword ptr ZoomFactor
;    imul    ecx
    shl     eax,8   ; ZoomFactor is 256 by default
    cdq
    mov     ecx,dword ptr Zt
    idiv    ecx
    add     eax,dword ptr CenterX
    mov     dword ptr _2DX,eax
    ; ---- _2DY:=CenterY-Trunc(Yt*ZoomFactor/Zt*13/16); ----
    mov     eax,dword ptr Yt
;    mov     ecx,dword ptr ZoomFactor
;    imul    ecx
    shl     eax,8   ; ZoomFactor is 256 by default
    cdq
    mov     ecx,dword ptr Zt
    idiv    ecx
    ;
    shl     eax,1        ; This part is the equivalent of:
    mov     ebx,eax      ; -----------
    shl     eax,1        ; mov ecx,13
    add     ebx,eax      ; imul ecx
    shl     eax,1        ; -----------
    add     eax,ebx      ;
    ;
    sar     eax,4
    mov     ebx,dword ptr CenterY
    sub     ebx,eax
    mov     dword ptr _2DY,ebx
    jmp     @Outta2
@NoPerspective2:
    ; ---- _2DX:=CenterX+Trunc(Xt); ----
    mov     eax,dword ptr Xt
    add     eax,dword ptr CenterX
    mov     dword ptr _2DX,eax
    ; ---- _2DY:=CenterY-Trunc(Yt*13/16); ----
    mov     eax,dword ptr Yt
    ;
    shl     eax,1        ; This part is the equivalent of:
    mov     ebx,eax      ; -----------
    shl     eax,1        ; mov ecx,13
    add     ebx,eax      ; imul ecx
    shl     eax,1        ; -----------
    add     eax,ebx      ;
    ;
    sar     eax,4
    mov     ebx,dword ptr CenterY
    sub     ebx,eax
    mov     dword ptr _2DY,ebx
@Outta2:
    retf
IntMapCoordinates2 endp

CODE  ends
      end
