program Keyboard_LED_Fun;

{ 20 October 1992 }

{
  By Morbid Man
}

uses
  Crt;

var
  Count : byte;

{

  Table for status bytes being changed:

  Bit     Key

   7      Insert
   6      Caps Lock
   5      Num Lock
   4      Scroll Lock
   3      Alt shift
   2      Ctrl shift
   1      Left shift key
   0      Right shift key

  When the changed bit = 1, the keyboard and computer assume that the
  key described has been pressed.  I am illustrating the use of this
  nifty code by messing with the keyboard Light Emitting Diodes (the
  idiot lights that turn on when you hit a Caps Lock, Num Lock, or
  Scroll Lock -- if your keyboard has them).

  If you get the byte that holds this information, and you AND
  the bit that you want the keyboard to read as having been pressed,
  it thinks you pressed it and should change the LED accordingly.

  If you get the byte and OR the bit ( 0 OR 0 = 0, 1 OR 0 = 1, 1 OR 1 = 1)
  it turns off the "key" that you pressed, via the software!
  (This is called programming to the metal!)  Nifty, huh?

  I've played around with this randomizing Count (so it would just blink
  at differing intervals, in no particular order.  I've also had
  it scroll to the left.  Anybody got any other ideas?  If so, send them
  to me!  (Hmmm...how about messing with disk drive lights?...)

  Here's an idea -- a mod player, that lets you sync the led's to a
  channel!

}

procedure NumLockOn; assembler;

  asm
    sub ax, ax                        { Set the extra segment to 0 }
    mov es, ax
    mov al, 100000b                   { Turn on bit 5              }
    or es:[417h], al                  { Change the status byte     }
  end;

procedure NumLockOff; assembler;

  asm
    xor ax, ax                        { Set the extra segment to 0 }
    mov es, ax
    mov al, 11011111b                 { Turn bit 5 off             }
    and es:[417h], al                 { Change the status byte     }
  end;

procedure CapsLockOn; assembler;

  asm
    xor ax, ax
    mov es, ax
    mov al, 1000000b
    or es:[417h], al
  end;

procedure CapsLockOff; assembler;

  asm
    xor ax, ax
    mov es, ax
    mov al, 10111111b
    and es:[417h], al
  end;

procedure ScrollLockOn; assembler;

  asm
    xor ax, ax
    mov es, ax
    mov al, 10000b
    or es:[417h], al
  end;

procedure ScrollLockOff; assembler;

  asm
    xor ax, ax
    mov es, ax
    mov al, 11101111b
    and es:[417h], al
  end;

begin
  Randomize;
  Count := 0;
  NumLockOff;
  CapsLockOff;
  ScrollLockOff;
  ClrScr;
  WriteLn ('Keyboard LED Demo.');
  WriteLn;
  WriteLn ('Press any key to quit...');
  WriteLn ('Look at your keyboard!!!  :)');
  repeat
    inc (Count);
    case Count of
      1 : begin
            CapsLockOff;
            NumLockOn
          end;
      2 : begin
            CapsLockOn;
            NumLockOff
          end;
      3 : begin
            ScrollLockOn;
            CapsLockOff
          end;
      4 : begin
            ScrollLockOff;
            CapsLockOn
          end;
    end;
    if Count = 4 then Count := 0;
    delay (250)                           { If you leave the delay out  }
  until keypressed;                       { it may not let you quit the }
  NumLockOff;                             { loop!  It will go too fast! }
  CapsLockOff;
  ScrollLockOff
end.